-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Jan 21, 2026 at 06:03 PM
-- Server version: 9.1.0
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `vsb`
--

-- --------------------------------------------------------

--
-- Table structure for table `admins`
--

DROP TABLE IF EXISTS `admins`;
CREATE TABLE IF NOT EXISTS `admins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fullname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `admins`
--

INSERT INTO `admins` (`id`, `fullname`, `email`, `password`) VALUES
(5, 'UMOH', 'u@gmail.com', '$2y$10$E09M7AwlhFgDHChnB2QTYOkcLF13WKyD/46mEruDAUcyHOSHLzNhO');

-- --------------------------------------------------------

--
-- Table structure for table `assessments`
--

DROP TABLE IF EXISTS `assessments`;
CREATE TABLE IF NOT EXISTS `assessments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `course_id` int DEFAULT NULL,
  `assessment_title` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `total_questions` int DEFAULT NULL,
  `duration` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `course_id` (`course_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `assessments`
--

INSERT INTO `assessments` (`id`, `course_id`, `assessment_title`, `total_questions`, `duration`) VALUES
(1, 6, 'Exams', 60, 40),
(2, 8, 'Data Analysis', 30, 40);

-- --------------------------------------------------------

--
-- Table structure for table `assignments`
--

DROP TABLE IF EXISTS `assignments`;
CREATE TABLE IF NOT EXISTS `assignments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `course_id` int NOT NULL,
  `due_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `assignment_submissions`
--

DROP TABLE IF EXISTS `assignment_submissions`;
CREATE TABLE IF NOT EXISTS `assignment_submissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `assignment_id` int NOT NULL,
  `user_id` int NOT NULL,
  `answer` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `file_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `submitted_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `grade` decimal(5,2) DEFAULT NULL,
  `feedback` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `assignment_submissions`
--

INSERT INTO `assignment_submissions` (`id`, `assignment_id`, `user_id`, `answer`, `file_path`, `submitted_at`, `grade`, `feedback`) VALUES
(1, 1, 11, 'Styling / Enhancements:\r\n\r\nCentered card with shadow-sm and no border for a clean look.\r\n\r\nHeader with colored background and white text.\r\n\r\nAssignment description displayed above the form in muted text.\r\n\r\nBootstrap validation for the textarea.\r\n\r\nResponsive layout: works nicely on mobile and desktop.\r\n\r\nButtons styled with success for submit and secondary for back.\r\n\r\nSubtle spacing and mb-* classes for neat padding/margin.\r\n\r\nFile upload field styled consistently with Bootstrap 5.\r\n\r\nIf you want, I can also add a preview of previously submitted files/answers for this student directly above the form, so they can see what they uploaded before submitting again.\r\n\r\nDo you want me to add that?', 'uploads/assignments/1765850990_HMOS[1].docx', '2025-12-16 02:09:50', 60.00, 'Good');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`) VALUES
(1, 'WEB DEVELOPMENT'),
(2, 'DATA  ANALYSIS'),
(3, 'CYBER SECURITY');

-- --------------------------------------------------------

--
-- Table structure for table `certificates`
--

DROP TABLE IF EXISTS `certificates`;
CREATE TABLE IF NOT EXISTS `certificates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `category_id` int NOT NULL,
  `certificate_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `issued_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_replies`
--

DROP TABLE IF EXISTS `comment_replies`;
CREATE TABLE IF NOT EXISTS `comment_replies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `comment_id` int NOT NULL,
  `admin_id` int NOT NULL,
  `reply_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `comment_id` (`comment_id`),
  KEY `admin_id` (`admin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `comment_replies`
--

INSERT INTO `comment_replies` (`id`, `comment_id`, `admin_id`, `reply_text`, `created_at`) VALUES
(1, 2, 5, 'ok', '2025-12-15 04:11:07'),
(2, 2, 5, 'ok', '2025-12-15 04:11:10'),
(3, 1, 5, 'noted', '2025-12-15 04:14:19'),
(4, 1, 5, 'noted', '2025-12-15 04:14:28'),
(5, 1, 5, 'noted', '2025-12-15 04:14:35'),
(6, 1, 5, 'noted', '2025-12-15 04:14:36'),
(7, 2, 5, 'okon', '2025-12-15 04:19:56'),
(8, 2, 5, 'okon', '2025-12-15 04:19:57');

-- --------------------------------------------------------

--
-- Table structure for table `contact_messages`
--

DROP TABLE IF EXISTS `contact_messages`;
CREATE TABLE IF NOT EXISTS `contact_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `is_read` tinyint DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `contact_messages`
--

INSERT INTO `contact_messages` (`id`, `name`, `email`, `subject`, `phone`, `message`, `is_read`, `created_at`) VALUES
(4, 'Umoh Ekpo', 'umohek@gmail.com', 'baba', '08134843148', 'Email\r\nsupport@exgis@gmail.com\r\nOffice Hours\r\nMonday – Friday\r\n9:00 AM – 5:00 PM', 1, '2025-12-19 20:48:54');

-- --------------------------------------------------------

--
-- Table structure for table `courses`
--

DROP TABLE IF EXISTS `courses`;
CREATE TABLE IF NOT EXISTS `courses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int DEFAULT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `subject` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `target_exams` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `has_assignments` tinyint(1) DEFAULT '0',
  `is_free` tinyint(1) GENERATED ALWAYS AS ((`price` = 0)) STORED,
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `thumbnail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `level` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `duration` int DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `fk_courses_created_by` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `courses`
--

INSERT INTO `courses` (`id`, `category_id`, `name`, `subject`, `target_exams`, `description`, `has_assignments`, `created_by`, `created_at`, `thumbnail`, `level`, `type`, `duration`, `price`, `file`, `deleted_at`) VALUES
(6, 1, 'Javascript', NULL, 'Digital Skill learners', '2__Which_Tools_to_Use_When_Developing_J', 1, NULL, '2025-12-11 18:05:51', 'thumb_693b07fdca166.jpg', 'intermediate', NULL, 4, 5000.00, 'file_693b07fdc9c20.mp4', NULL),
(7, 1, 'Javascript', NULL, 'Digital Skill learners', '2__Which_Tools_to_Use_When_Developing_JavaScript___JavaScrip', 1, 11, '2025-12-12 16:24:20', 'thumb_693c41b05b45b.jpg', 'intermediate', NULL, 4, 5000.00, 'file_693c41b05ab58.mp4', NULL),
(8, 2, 'DATA  ANALYSIS', NULL, 'Digital Skill learners', 'Introduction_to_Data_Analysis_with_Excel__2-Hour_Training_Tutorial(360p)', 1, 5, '2025-12-13 19:12:52', 'thumb_693dbab0d9478.jpg', 'Beginner', NULL, 4, 23455.00, 'file_693dbab0d8f43.mp4', NULL),
(9, 2, 'DATA  science', NULL, 'Digital Skill learners', 'daat', 1, 5, '2025-12-13 19:15:53', 'thumb_693dbb68b8c40.jpg', 'intermediate', NULL, 4, 2345.00, 'file_693dbb68b67bd.mp4', NULL),
(10, 3, 'Mr. Odey David', NULL, 'Digital Skill learners', 'Full texts\r\nid\r\nuser_id\r\nNULL = notify all, user_id = specific student\r\ntitle\r\nmessage\r\nlink\r\nis_read\r\ncreated_at', 1, 5, '2025-12-20 00:11:03', 'thumb_6945e9970176b.jpg', 'intermediate', NULL, 40, 5000.00, 'video_6945e9970115a.mp4', NULL),
(11, 3, 'Shirt', NULL, 'Digital Skill learners', 'li.onclick = () => {\r\n    // Remove clicked notification from dropdown immediately\r\n    li.remove();\r\n\r\n    // Update unread count\r\n    const count = document.getElementById(\'notifCount\');\r\n    let unread = parseInt(count.innerText) || 0;\r\n    unread = Math.max(unread - 1, 0);\r\n    if(unread === 0){\r\n        count.style.display = \'none\';\r\n    } else {\r\n        count.innerText = unread;\r\n    }\r\n\r\n    // Mark as read in DB\r\n    fetch(\'mark_notif_read.php\', {\r\n        method: \'POST\',\r\n        headers: {\'Content-Type\': \'application/x-www-form-urlencoded\'},\r\n        body: \'id=\' + encodeURIComponent(n.id)\r\n    });\r\n\r\n    // Redirect if there is a link\r\n    if(n.link) window.location.href = n.link;\r\n};', 1, 5, '2025-12-20 00:30:25', 'thumb_6945ee2130222.jpg', 'hard', NULL, 40, 900.00, 'video_6945ee212fc13.mp4', NULL),
(12, 3, 'Car', NULL, 'Digital Skill learners', '$sql = \"UPDATE courses SET deleted_at = NOW() WHERE id = :id\";\r\n$stmt = $pdo->prepare($sql);', 1, 5, '2025-12-28 11:39:58', 'thumb_69511705938f0.jpg', 'intermediate', NULL, 4, 900.00, 'file_695117059273b.mp4', NULL),
(13, 3, 'Car', NULL, 'Digital Skill learners', 'session_start();\r\n\r\nif (!isset($_SESSION[\'user\']) || $_SESSION[\'user\'][\'role\'] !== \'admin\') {\r\n    header(\'Location: ../login.php\');\r\n    exit;\r\n}\r\n', 1, 5, '2025-12-28 11:57:23', 'thumb_69511b2251b51.jpg', 'intermediate', NULL, 6, 900.00, 'file_69511b22516c2.mp4', '2025-12-28 13:02:26');

-- --------------------------------------------------------

--
-- Table structure for table `course_links`
--

DROP TABLE IF EXISTS `course_links`;
CREATE TABLE IF NOT EXISTS `course_links` (
  `id` int NOT NULL AUTO_INCREMENT,
  `course_id` int NOT NULL,
  `platform` enum('zoom','meet') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `start_time` datetime DEFAULT NULL,
  `duration` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `course_links`
--

INSERT INTO `course_links` (`id`, `course_id`, `platform`, `link`, `created_at`, `start_time`, `duration`) VALUES
(4, 7, 'zoom', 'http://excellentgrade.ng/EXCELLENTHUB', '2025-12-13 11:43:30', '2025-12-20 12:43:00', 60),
(3, 6, 'zoom', 'http://excellentgrade.ng/EXCELLENTHUB', '2025-12-13 11:00:36', '2025-12-14 12:00:00', 60);

-- --------------------------------------------------------

--
-- Table structure for table `course_modules`
--

DROP TABLE IF EXISTS `course_modules`;
CREATE TABLE IF NOT EXISTS `course_modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `course_id` int DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `video_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_order` int DEFAULT NULL,
  `is_free` tinyint(1) DEFAULT '0',
  `parent_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `course_modules`
--

INSERT INTO `course_modules` (`id`, `course_id`, `title`, `video_file`, `module_order`, `is_free`, `parent_id`) VALUES
(1, 1, 'Introduction', 'intro.mp4', 1, 1, NULL),
(2, 1, 'Variables', 'variables.mp4', 2, 0, NULL),
(3, 1, 'Loops', 'loops.mp4', 3, 0, NULL),
(4, 1, 'Functions', 'functions.mp4', 4, 0, NULL),
(5, 6, 'INTRODUCTION', 'module_696f9412b8961.mp4', 1, 1, NULL),
(6, 12, 'INTRODUCTION', 'module_696f94cda0195.mp4', 1, 1, NULL),
(7, 7, 'variable', 'module_696fd98964f35.mp4', 2, 0, NULL),
(8, 7, 'looping', 'module_696fd9bb0d37e.mp4', 3, 0, NULL),
(9, 7, 'conditions', 'module_696fe28d86a57.mp4', 3, 0, NULL),
(10, 7, 'vas', 'module_696ffb9421725.mp4', 4, 0, NULL),
(11, 7, 'if, elseif', 'module_6970c0c5455d2.mp4', 5, 0, 9);

-- --------------------------------------------------------

--
-- Table structure for table `favorites`
--

DROP TABLE IF EXISTS `favorites`;
CREATE TABLE IF NOT EXISTS `favorites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `course_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ux_user_course` (`user_id`,`course_id`),
  KEY `course_id` (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `live_class_attendance`
--

DROP TABLE IF EXISTS `live_class_attendance`;
CREATE TABLE IF NOT EXISTS `live_class_attendance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `course_id` int NOT NULL,
  `joined_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `warned_10min` tinyint(1) DEFAULT '0',
  `warned_5min` tinyint(1) DEFAULT '0',
  `stayed_till_end` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_user_course` (`user_id`,`course_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `live_class_logs`
--

DROP TABLE IF EXISTS `live_class_logs`;
CREATE TABLE IF NOT EXISTS `live_class_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `course_id` int DEFAULT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_log` (`user_id`,`course_id`,`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `module_progress`
--

DROP TABLE IF EXISTS `module_progress`;
CREATE TABLE IF NOT EXISTS `module_progress` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `module_id` int DEFAULT NULL,
  `completed` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL COMMENT 'NULL = notify all, user_id = specific student',
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `notifications`
--

INSERT INTO `notifications` (`id`, `user_id`, `title`, `message`, `link`, `is_read`, `created_at`) VALUES
(48, 11, '📂 New Assignment Added', 'Assignment \"ekpo\" has been added.', 'assignments.php', 0, '2026-01-07 19:44:07'),
(47, 11, '📂 New Assignment Added', 'Assignment \"ekpo\" has been added.', 'assignments.php', 0, '2026-01-07 19:44:07'),
(46, 11, '📂 New Assignment Added', 'Assignment \"ekpo\" has been added.', 'assignments.php', 0, '2026-01-07 19:44:07'),
(45, 11, '📂 New Assignment Added', 'Assignment \"ekpo\" has been added.', 'assignments.php', 0, '2026-01-07 19:44:07'),
(44, 11, '📂 New Assignment Added', 'Assignment \"ekpo\" has been added.', 'assignments.php', 0, '2026-01-07 19:44:07');

-- --------------------------------------------------------

--
-- Table structure for table `previews`
--

DROP TABLE IF EXISTS `previews`;
CREATE TABLE IF NOT EXISTS `previews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `course_id` int NOT NULL,
  `file_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `course_id` (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `questions`
--

DROP TABLE IF EXISTS `questions`;
CREATE TABLE IF NOT EXISTS `questions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `assessment_id` int DEFAULT NULL,
  `question` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `option_a` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `option_b` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `option_c` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `option_d` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `correct_option` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `explanation_correct` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `explanation_wrong` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `explanation` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`),
  KEY `assessment_id` (`assessment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `questions`
--

INSERT INTO `questions` (`id`, `assessment_id`, `question`, `option_a`, `option_b`, `option_c`, `option_d`, `correct_option`, `explanation_correct`, `explanation_wrong`, `explanation`) VALUES
(105, 1, 'Which HTML attribute specifies an alternate text for an image?', 'alt', 'src', 'title', 'description', 'A', 'Correct! The alt attribute specifies alternate text.', 'Incorrect! The correct attribute is \"alt\".', NULL),
(104, 1, 'What is the correct HTML element for inserting a line break?', '<break>', '<lb>', '<br>', '<hr>', 'C', 'Correct! <br> inserts a line break.', 'Incorrect! <br> is used for line breaks.', NULL),
(99, 1, 'What does CSS stand for?', 'Creative Style Sheets', 'Cascading Style Sheets', 'Colorful Style Sheets', 'Computer Style Sheets', 'B', 'Correct! CSS stands for Cascading Style Sheets.', 'Incorrect! CSS stands for Cascading Style Sheets.', NULL),
(100, 1, 'Which HTML attribute is used to define inline styles?', 'class', 'styles', 'style', 'css', 'C', 'Correct! The style attribute is used for inline styles.', 'Incorrect! The correct attribute is \"style\".', NULL),
(101, 1, 'Which property is used to change the text color in CSS?', 'font-color', 'text-color', 'color', 'background-color', 'C', 'Correct! \"color\" changes the text color.', 'Incorrect! The correct property is \"color\".', NULL),
(102, 1, 'Which HTML tag defines a paragraph?', '<p>', '<para>', '<paragraph>', '<pg>', 'A', 'Correct! <p> is the paragraph tag.', 'Incorrect! The <p> tag is used for paragraphs.', NULL),
(103, 1, 'Which CSS property changes the background color?', 'bgcolor', 'background-color', 'color', 'background', 'B', 'Correct! \"background-color\" sets the background color.', 'Incorrect! The correct property is \"background-color\".', NULL),
(98, 1, 'Which tag is used to define a hyperlink in HTML?', '<a>', '<link>', '<href>', '<hyperlink>', 'A', 'Correct! <a> tag is used for hyperlinks.', 'Incorrect! The <a> tag is the proper tag for hyperlinks.', NULL),
(106, 1, 'Which HTML tag is used for the largest heading?', '<heading>', '<h6>', '<h1>', '<head>', 'C', 'Correct! <h1> is the largest heading.', 'Incorrect! <h1> is the largest heading, not <h6>.', NULL),
(107, 1, 'Which CSS property is used to make text bold?', 'font-weight', 'text-decoration', 'font-style', 'font-bold', 'A', 'Correct! \"font-weight: bold\" makes text bold.', 'Incorrect! The correct property is \"font-weight\".', NULL),
(108, 1, 'Which HTML tag is used to define an unordered list?', '<ul>', '<ol>', '<li>', '<list>', 'A', 'Correct! <ul> defines an unordered list.', 'Incorrect! <ul> is the unordered list tag.', NULL),
(109, 1, 'Which HTML tag is used to define a table row?', '<td>', '<tr>', '<table>', '<row>', 'B', 'Correct! <tr> defines a table row.', 'Incorrect! The correct tag is <tr>.', NULL),
(110, 1, 'Which HTML tag is used to define a table cell?', '<tr>', '<td>', '<th>', '<table>', 'B', 'Correct! <td> defines a table cell.', 'Incorrect! The correct tag is <td>.', NULL),
(111, 1, 'Which CSS property controls the text size?', 'font-size', 'text-size', 'font-style', 'text-style', 'A', 'Correct! font-size controls text size.', 'Incorrect! The correct property is \"font-size\".', NULL),
(112, 1, 'Which tag is used to embed JavaScript in HTML?', '<javascript>', '<js>', '<script>', '<code>', 'C', 'Correct! <script> is used for JavaScript.', 'Incorrect! The correct tag is <script>.', NULL),
(113, 1, 'Which HTML element defines the title of a document?', '<title>', '<head>', '<header>', '<meta>', 'A', 'Correct! <title> defines the page title.', 'Incorrect! The correct tag is <title>.', NULL),
(114, 1, 'Which attribute is used to specify an image source?', 'alt', 'src', 'href', 'link', 'B', 'Correct! The src attribute specifies the image source.', 'Incorrect! The correct attribute is \"src\".', NULL),
(115, 1, 'Which CSS property is used to change the font family?', 'font-family', 'font-style', 'font-weight', 'font-type', 'A', 'Correct! font-family changes the font.', 'Incorrect! The correct property is \"font-family\".', NULL),
(116, 1, 'Which HTML tag is used to define a list item?', '<li>', '<ul>', '<ol>', '<list>', 'A', 'Correct! <li> defines a list item.', 'Incorrect! The correct tag is <li>.', NULL),
(117, 1, 'Which HTML tag is used to create a numbered list?', '<ol>', '<ul>', '<li>', '<list>', 'A', 'Correct! <ol> defines an ordered list.', 'Incorrect! The correct tag is <ol>.', NULL),
(118, 1, 'Which CSS property sets the element width?', 'width', 'height', 'size', 'length', 'A', 'Correct! The width property sets element width.', 'Incorrect! The correct property is \"width\".', NULL),
(119, 1, 'Which CSS property sets the element height?', 'width', 'height', 'size', 'length', 'B', 'Correct! The height property sets element height.', 'Incorrect! The correct property is \"height\".', NULL),
(120, 1, 'Which HTML tag is used for emphasized text?', '<em>', '<i>', '<strong>', '<b>', 'A', 'Correct! <em> emphasizes text.', 'Incorrect! <em> is used for emphasis.', NULL),
(121, 1, 'Which CSS property is used to change the text alignment?', 'text-align', 'align', 'alignment', 'text-position', 'A', 'Correct! text-align controls text alignment.', 'Incorrect! The correct property is \"text-align\".', NULL),
(122, 1, 'Which HTML tag is used to define the main content of a document?', '<main>', '<body>', '<section>', '<content>', 'A', 'Correct! <main> defines main content.', 'Incorrect! The correct tag is <main>.', NULL),
(123, 1, 'Which HTML tag is used for a horizontal line?', '<hr>', '<line>', '<break>', '<hl>', 'A', 'Correct! <hr> defines a horizontal line.', 'Incorrect! The correct tag is <hr>.', NULL),
(124, 1, 'Which HTML tag is used to create a dropdown list?', '<dropdown>', '<select>', '<input>', '<list>', 'B', 'Correct! <select> creates a dropdown.', 'Incorrect! The correct tag is <select>.', NULL),
(125, 1, 'Which attribute specifies the default selected option in a dropdown?', 'selected', 'default', 'value', 'option', 'A', 'Correct! The selected attribute defines the default option.', 'Incorrect! The correct attribute is \"selected\".', NULL),
(126, 1, 'Which CSS property controls the space between lines?', 'line-height', 'text-spacing', 'margin', 'padding', 'A', 'Correct! line-height sets line spacing.', 'Incorrect! The correct property is \"line-height\".', NULL),
(127, 1, 'Which HTML tag is used to define a footer section?', '<footer>', '<bottom>', '<section>', '<foot>', 'A', 'Correct! <footer> defines footer content.', 'Incorrect! The correct tag is <footer>.', NULL),
(128, 1, 'Which CSS property adds space inside an element?', 'margin', 'padding', 'spacing', 'border', 'B', 'Correct! padding adds space inside.', 'Incorrect! The correct property is \"padding\".', NULL),
(129, 1, 'Which CSS property adds space outside an element?', 'margin', 'padding', 'spacing', 'border', 'A', 'Correct! margin adds space outside.', 'Incorrect! The correct property is \"margin\".', NULL),
(130, 1, 'Which HTML tag is used to define a section?', '<section>', '<div>', '<article>', '<content>', 'A', 'Correct! <section> defines a section.', 'Incorrect! The correct tag is <section>.', NULL),
(131, 1, 'Which CSS property is used for element borders?', 'border', 'outline', 'stroke', 'frame', 'A', 'Correct! border defines element borders.', 'Incorrect! The correct property is \"border\".', NULL),
(132, 1, 'Which HTML tag is used for the head section of a document?', '<header>', '<head>', '<title>', '<meta>', 'B', 'Correct! <head> is for meta information.', 'Incorrect! The correct tag is <head>.', NULL),
(133, 1, 'Which CSS property changes the list item marker type?', 'list-style', 'marker-style', 'list-type', 'item-style', 'A', 'Correct! list-style controls marker type.', 'Incorrect! The correct property is \"list-style\".', NULL),
(134, 1, 'Which HTML tag is used for a navigation menu?', '<nav>', '<menu>', '<navigation>', '<ul>', 'A', 'Correct! <nav> is for navigation.', 'Incorrect! The correct tag is <nav>.', NULL),
(135, 1, 'Which CSS property changes text decoration (like underline)?', 'text-decoration', 'text-style', 'font-decoration', 'font-style', 'A', 'Correct! text-decoration controls underline, overline, etc.', 'Incorrect! The correct property is \"text-decoration\".', NULL),
(136, 1, 'Which HTML attribute specifies the URL of a link?', 'src', 'href', 'link', 'url', 'B', 'Correct! href defines the link URL.', 'Incorrect! The correct attribute is \"href\".', NULL),
(137, 1, 'Which HTML tag is used to embed video?', '<video>', '<media>', '<embed>', '<movie>', 'A', 'Correct! <video> embeds video.', 'Incorrect! The correct tag is <video>.', NULL),
(138, 1, 'Which attribute defines video controls?', 'controls', 'video-controls', 'controls-video', 'control', 'A', 'Correct! controls attribute enables video controls.', 'Incorrect! The correct attribute is \"controls\".', NULL),
(139, 1, 'Which HTML tag is used to embed audio?', '<audio>', '<sound>', '<media>', '<track>', 'A', 'Correct! <audio> embeds audio.', 'Incorrect! The correct tag is <audio>.', NULL),
(140, 1, 'Which HTML tag is used for bold text?', '<strong>', '<b>', '<bold>', '<em>', 'A', 'Correct! <strong> is the semantic bold.', 'Incorrect! <strong> is correct, <b> is visual only.', NULL),
(141, 1, 'Which CSS property changes the element visibility?', 'display', 'visibility', 'hidden', 'opacity', 'B', 'Correct! visibility controls visibility.', 'Incorrect! The correct property is \"visibility\".', NULL),
(142, 1, 'Which HTML tag is used to create a form?', '<form>', '<input>', '<fieldset>', '<section>', 'A', 'Correct! <form> creates a form.', 'Incorrect! The correct tag is <form>.', NULL),
(143, 1, 'Which attribute defines form submission URL?', 'action', 'href', 'src', 'url', 'A', 'Correct! action specifies form submission.', 'Incorrect! The correct attribute is \"action\".', NULL),
(144, 1, 'Which input type allows multiple lines of text?', 'text', 'textarea', 'multitext', 'paragraph', 'B', 'Correct! <textarea> allows multiple lines.', 'Incorrect! The correct tag is <textarea>.', NULL),
(145, 1, 'Which HTML attribute disables an input field?', 'disable', 'disabled', 'readonly', 'block', 'B', 'Correct! disabled disables input.', 'Incorrect! The correct attribute is \"disabled\".', NULL),
(146, 1, 'Which CSS property changes text case?', 'text-case', 'text-transform', 'font-case', 'case', 'B', 'Correct! text-transform controls case.', 'Incorrect! The correct property is \"text-transform\".', NULL),
(147, 1, 'Which HTML tag is used for inline text styling?', '<span>', '<div>', '<p>', '<section>', 'A', 'Correct! <span> is for inline styling.', 'Incorrect! The correct tag is <span>.', NULL),
(148, 2, 'Which HTML attribute specifies an alternate text f', 'alt', 'src', '<script>', 'php', 'c', 'c', 'd', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `results`
--

DROP TABLE IF EXISTS `results`;
CREATE TABLE IF NOT EXISTS `results` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `assessment_id` int DEFAULT NULL,
  `score` int DEFAULT NULL,
  `total_questions` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `results`
--

INSERT INTO `results` (`id`, `user_id`, `assessment_id`, `score`, `total_questions`, `created_at`) VALUES
(13, 11, 1, 41, 50, '2025-12-16 01:01:32'),
(14, 11, 2, 1, 1, '2025-12-19 22:29:34');

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

DROP TABLE IF EXISTS `subscriptions`;
CREATE TABLE IF NOT EXISTS `subscriptions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `course_id` int DEFAULT NULL,
  `plan` enum('regular','premium') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `number` int NOT NULL DEFAULT '1',
  `amount` decimal(10,2) NOT NULL,
  `reference` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `payment_status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_method` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'paystack',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  UNIQUE KEY `reference_2` (`reference`),
  UNIQUE KEY `unique_user_course` (`user_id`,`course_id`),
  KEY `fk_sub_user` (`user_id`),
  KEY `fk_sub_course` (`course_id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `subscriptions`
--

INSERT INTO `subscriptions` (`id`, `user_id`, `course_id`, `plan`, `number`, `amount`, `reference`, `paid_at`, `created_at`, `start_date`, `end_date`, `payment_status`, `payment_method`) VALUES
(198, 18, 7, 'premium', 1, 10000.00, 'SUB1768990394760', '2026-01-21 10:13:25', '2026-01-21 10:13:14', '2026-01-21', '2026-02-20', 'paid', 'paystack');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fullname` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `role` enum('admin','student') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'student',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reset_token` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `token_expiry` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `fullname`, `email`, `password`, `role`, `created_at`, `reset_token`, `token_expiry`) VALUES
(18, 'Umoh Ekpo', 'umohek@gmail.com', '$2y$10$NEQKRR37u1zj0AmArlnLHulnARbxB4bDFkwRW43CeOsIXLuEBPlEW', 'student', '2026-01-21 08:55:06', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_modules`
--

DROP TABLE IF EXISTS `user_modules`;
CREATE TABLE IF NOT EXISTS `user_modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `module_id` int DEFAULT NULL,
  `watched` tinyint(1) DEFAULT '0',
  `subscribed` tinyint(1) DEFAULT '0',
  `completed_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `video_comments`
--

DROP TABLE IF EXISTS `video_comments`;
CREATE TABLE IF NOT EXISTS `video_comments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `course_id` int NOT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `video_comments`
--

INSERT INTO `video_comments` (`id`, `user_id`, `course_id`, `comment`, `created_at`) VALUES
(1, 11, 6, 'good', '2025-12-12 19:26:48'),
(2, 11, 6, 'poo', '2025-12-13 00:48:33');

-- --------------------------------------------------------

--
-- Table structure for table `video_progress`
--

DROP TABLE IF EXISTS `video_progress`;
CREATE TABLE IF NOT EXISTS `video_progress` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `course_id` int NOT NULL,
  `video_id` int NOT NULL,
  `watched` tinyint(1) DEFAULT '0',
  `watched_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `favorites`
--
ALTER TABLE `favorites`
  ADD CONSTRAINT `favorites_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `favorites_ibfk_2` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `previews`
--
ALTER TABLE `previews`
  ADD CONSTRAINT `previews_ibfk_1` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD CONSTRAINT `fk_sub_course` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_sub_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
