<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

// Get assignment ID from URL
$assignment_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($assignment_id <= 0) {
    echo "Invalid assignment ID.";
    exit;
}

// Fetch assignment details
$stmt = $pdo->prepare("SELECT * FROM assignments WHERE id = ?");
$stmt->execute([$assignment_id]);
$assignment = $stmt->fetch();

if (!$assignment) {
    echo "Assignment not found.";
    exit;
}

// Fetch the latest submission for this user and assignment
$subStmt = $pdo->prepare("
    SELECT * FROM assignment_submissions
    WHERE assignment_id = :aid AND user_id = :uid
    ORDER BY submitted_at DESC
    LIMIT 1
");
$subStmt->execute([
    'aid' => $assignment_id,
    'uid' => $user_id
]);
$submission = $subStmt->fetch();
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>View Submission</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    body {
        background-color: #f8f9fa;
    }
    .card-header {
        background: linear-gradient(90deg, #0d6efd, #6610f2);
        color: #fff;
        font-weight: 600;
        font-size: 1.2rem;
    }
    .submission-box {
        background-color: #eef5ff;
        border-left: 4px solid #0d6efd;
        padding: 15px;
        border-radius: 6px;
        margin-bottom: 15px;
        max-height: 300px; /* limit height */
        overflow-y: auto;  /* enable vertical scroll */
    }
    .file-link {
        color: #0d6efd;
        text-decoration: none;
        font-weight: 500;
    }
    .file-link:hover {
        text-decoration: underline;
    }
    .back-btn {
        margin-top: 10px;
    }
</style>
</head>
<body>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm border-0">
                <div class="card-header">
                    📝 View Submission: <?= htmlspecialchars($assignment['title']) ?>
                </div>
                <div class="card-body">
                    <?php if ($submission): ?>
                        <div class="submission-box">
                            <p><strong>Answer / Notes:</strong></p>
                            <div class="mb-3"><?= nl2br(htmlspecialchars($submission['answer'])) ?></div>

                            <?php if (!empty($submission['file_path'])): ?>
                                <p>
                                    <strong>Uploaded File:</strong>
                                    <a href="<?= htmlspecialchars($submission['file_path']) ?>" target="_blank" class="file-link">View File</a>
                                </p>
                            <?php endif; ?>

                            <small class="text-muted">
                                Submitted on: <?= date('d M Y, H:i', strtotime($submission['submitted_at'])) ?>
                            </small>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">
                            No submission found for this assignment.
                        </div>
                    <?php endif; ?>

                    <a href="assignments.php" class="btn btn-secondary back-btn">⬅ Back to Assignments</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
