<?php
require_once "config.php";

$code = $_GET['code'];

$stmt = $pdo->prepare("
    SELECT c.*, u.fullname, cat.name AS category
    FROM certificates c
    JOIN users u ON u.id = c.user_id
    JOIN categories cat ON cat.id = c.category_id
    WHERE c.certificate_code = ?
");
$stmt->execute([$code]);
$cert = $stmt->fetch();
?>

<!DOCTYPE html>
<html>
<head>
<title>Certificate</title>
<style>
body { font-family: serif; background:#f4f4f4; }
.cert {
    background:white;
    padding:50px;
    margin:40px auto;
    width:80%;
    border:10px solid #2c3e50;
    text-align:center;
}
</style>
</head>
<body>
<div class="cert">
    <h1>Certificate of Completion</h1>
    <p>This certifies that</p>
    <h2><?= htmlspecialchars($cert['fullname']) ?></h2>
    <p>has successfully completed</p>
    <h3><?= htmlspecialchars($cert['category']) ?></h3>
    <p>Date: <?= date("d M Y", strtotime($cert['issued_at'])) ?></p>
    <p><strong><?= $cert['certificate_code'] ?></strong></p>
</div>
</body>
</html>
