<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

$assignment_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($assignment_id <= 0) {
    echo "Invalid assignment.";
    exit;
}

// Fetch assignment details
$stmt = $pdo->prepare("SELECT * FROM assignments WHERE id = ?");
$stmt->execute([$assignment_id]);
$assignment = $stmt->fetch();

if (!$assignment) {
    echo "Assignment not found.";
    exit;
}

// Fetch previous submission
$subStmt = $pdo->prepare("
    SELECT * FROM assignment_submissions
    WHERE assignment_id = :aid AND user_id = :uid
    ORDER BY submitted_at DESC
    LIMIT 1
");
$subStmt->execute([
    'aid' => $assignment_id,
    'uid' => $user_id
]);
$previous = $subStmt->fetch();

// Handle new submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $answer = $_POST['answer'] ?? '';
    $filePath = $previous['file_path'] ?? null;

    if (!empty($_FILES['file']['name'])) {
        $uploadDir = 'uploads/assignments/';
        $filePath = $uploadDir . time() . '_' . basename($_FILES['file']['name']);
        move_uploaded_file($_FILES['file']['tmp_name'], $filePath);
    }

    $stmt = $pdo->prepare("
        INSERT INTO assignment_submissions (assignment_id, user_id, answer, file_path)
        VALUES (:aid, :uid, :answer, :file)
    ");
    $stmt->execute([
        'aid' => $assignment_id,
        'uid' => $user_id,
        'answer' => $answer,
        'file' => $filePath
    ]);

    header("Location: assignments.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Submit Assignment</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
    background-color: #f0f2f5;
}
.card-header {
    background: linear-gradient(90deg, #0d6efd, #6610f2);
    color: #fff;
    font-weight: 600;
    font-size: 1.2rem;
}
.previous-submission {
    background-color: #eef5ff;
    border-left: 4px solid #0d6efd;
    padding: 15px;
    border-radius: 6px;
    margin-bottom: 20px;
    max-height: 250px;
    overflow-y: auto;
}
textarea.form-control {
    max-height: 200px;
    overflow-y: auto;
}
.file-link {
    color: #0d6efd;
    font-weight: 500;
    text-decoration: none;
}
.file-link:hover {
    text-decoration: underline;
}
.back-btn {
    margin-top: 10px;
}
</style>
</head>
<body>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm border-0">
                <div class="card-header">
                    📄 Submit Assignment: <?= htmlspecialchars($assignment['title']) ?>
                </div>
                <div class="card-body">

                    <!-- Previous Submission -->
                    <?php if (is_array($previous) && $previous): ?>
                        <div class="previous-submission">
                            <h6 class="fw-semibold">📝 Previous Submission</h6>
                            <p><strong>Answer:</strong></p>
                            <div><?= nl2br(htmlspecialchars($previous['answer'] ?? '')) ?></div>

                            <?php if (!empty($previous['file_path'])): ?>
                                <p>
                                    <strong>Uploaded File:</strong>
                                    <a href="<?= htmlspecialchars($previous['file_path']) ?>" target="_blank" class="file-link">View File</a>
                                </p>
                            <?php endif; ?>

                            <small class="text-muted">
                                Submitted on: <?= !empty($previous['submitted_at']) ? date('d M Y, H:i', strtotime($previous['submitted_at'])) : '' ?>
                            </small>
                        </div>
                    <?php endif; ?>

                    <!-- New Submission Form -->
                    <form method="post" enctype="multipart/form-data" class="needs-validation" novalidate>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Answer / Notes</label>
                            <textarea name="answer" class="form-control" rows="6" placeholder="Write your answer here..." required><?= htmlspecialchars($previous['answer'] ?? '') ?></textarea>
                            <div class="invalid-feedback">
                                Please provide your answer.
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label fw-semibold">Upload File (optional)</label>
                            <input type="file" name="file" class="form-control">
                            <?php if (!empty($previous['file_path'])): ?>
                                <small class="text-muted">Current file: <a href="<?= htmlspecialchars($previous['file_path']) ?>" target="_blank" class="file-link">View</a></small>
                            <?php endif; ?>
                        </div>

                        <div class="d-flex justify-content-between">
                            <button type="submit" class="btn btn-success">✅ Submit Assignment</button>
                            <a href="assignments.php" class="btn btn-secondary back-btn">⬅ Back to Assignments</a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
(() => {
    'use strict';
    const forms = document.querySelectorAll('.needs-validation');
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>
</body>
</html>
