<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

// Fetch student submissions with assignment info
$stmt = $pdo->prepare("
    SELECT 
        a.title AS assignment_title, 
        a.due_date, 
        s.answer, 
        s.file_path, 
        s.grade, 
        s.feedback, 
        s.submitted_at
    FROM assignment_submissions s
    JOIN assignments a ON s.assignment_id = a.id
    WHERE s.user_id = ?
    ORDER BY s.submitted_at DESC
");
$stmt->execute([$user_id]);
$submissions = $stmt->fetchAll(PDO::FETCH_ASSOC);

require_once 'includes/header.php';
?>

<style>
/* =========================
   RESPONSIVE TABLE CSS
========================= */
.table-responsive-custom {
    width: 100%;
}

@media (max-width: 768px) {
    table,
    thead,
    tbody,
    th,
    td,
    tr {
        display: block;
        width: 100%;
    }

    thead {
        display: none;
    }

    tr {
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 8px;
        margin-bottom: 20px;
        padding: 10px;
    }

    td {
        display: flex;
        justify-content: space-between;
        gap: 10px;
        border: none;
        border-bottom: 1px solid #eee;
        padding: 8px 0;
        font-size: 0.95rem;
    }

    td:last-child {
        border-bottom: none;
    }

    td::before {
        content: attr(data-label);
        font-weight: bold;
        color: #555;
        flex: 0 0 40%;
    }

    .answer-cell {
        flex-direction: column;
    }

    .answer-cell::before {
        margin-bottom: 6px;
    }
}
</style>

<div class="container mt-5">
    <h3 class="mb-4">📊 My Assignment Grades</h3>

    <?php if (empty($submissions)): ?>
        <div class="alert alert-info">
            You have not submitted any assignments yet.
        </div>
    <?php else: ?>
        <div class="table-responsive-custom">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Assignment</th>
                        <th>Submitted At</th>
                        <th>Grade</th>
                        <th>Feedback</th>
                        <th>Answer / File</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($submissions as $i => $s): ?>
                    <tr>
                        <td data-label="#">
                            <?= $i + 1 ?>
                        </td>

                        <td data-label="Assignment">
                            <?= htmlspecialchars($s['assignment_title']) ?>
                        </td>

                        <td data-label="Submitted At">
                            <?= date('d M Y, H:i', strtotime($s['submitted_at'])) ?>
                        </td>

                        <td data-label="Grade">
                            <?php if ($s['grade'] !== null): ?>
                                <span class="badge bg-success">
                                    <?= htmlspecialchars($s['grade']) ?>%
                                </span>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark">
                                    Not Graded
                                </span>
                            <?php endif; ?>
                        </td>

                        <td data-label="Feedback">
                            <?= nl2br(htmlspecialchars($s['feedback'] ?? '—')) ?>
                        </td>

                        <td data-label="Answer / File" class="answer-cell">
                            <strong>Answer:</strong>
                            <?= nl2br(htmlspecialchars($s['answer'] ?? '—')) ?>

                            <?php if (!empty($s['file_path'])): ?>
                                <a href="<?= htmlspecialchars($s['file_path']) ?>" 
                                   target="_blank" 
                                   class="btn btn-sm btn-outline-primary mt-2">
                                    📎 View File
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <a href="assignments.php" class="btn btn-secondary mt-3">
        ⬅ Back to Assignments
    </a>
</div>

<?php
//  require_once 'includes/footer.php'; ?>
