<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];
$assessment_id = $_GET['id'] ?? 0;

/* 🔐 SECURITY CHECK */
$stmt = $pdo->prepare("
SELECT a.assessment_title 
FROM assessments a
JOIN courses c ON a.course_id = c.id
JOIN subscriptions s ON s.course_id = c.id
WHERE a.id = :aid
AND s.user_id = :uid
AND s.payment_status = 'paid'
");
$stmt->execute([
    'aid' => $assessment_id,
    'uid' => $user_id
]);

$assessment = $stmt->fetch();
if (!$assessment) die("❌ Access denied");

/* 🔢 PAGINATION */
$limit = 10;
$page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($page - 1) * $limit;

/* 📦 SAVE ANSWERS INTO SESSION */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST['answers'] ?? [] as $qid => $ans) {
        $_SESSION['exam_answers'][$assessment_id][$qid] = $ans;
    }
}

/* 📚 TOTAL QUESTIONS */
$countStmt = $pdo->prepare("
SELECT COUNT(*) FROM questions WHERE assessment_id = :aid
");
$countStmt->execute(['aid' => $assessment_id]);
$total_questions = $countStmt->fetchColumn();

$total_pages = ceil($total_questions / $limit);

/* 📚 LOAD 10 QUESTIONS */
$qstmt = $pdo->prepare("
SELECT id, question, option_a, option_b, option_c, option_d
FROM questions
WHERE assessment_id = :aid
ORDER BY id ASC
LIMIT :limit OFFSET :offset
");
$qstmt->bindValue(':aid', $assessment_id, PDO::PARAM_INT);
$qstmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$qstmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$qstmt->execute();

$questions = $qstmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!doctype html>
<html>
<head>
<title><?= htmlspecialchars($assessment['assessment_title']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">
<h4><?= htmlspecialchars($assessment['assessment_title']) ?></h4>
<p class="text-muted">Page <?= $page ?> of <?= $total_pages ?></p>

<form method="post">

<?php foreach ($questions as $index => $q): ?>
<div class="card mb-3 shadow-sm">
<div class="card-body">

<p class="fw-bold">
Q<?= (($page-1)*$limit) + $index + 1 ?>.
<?= htmlspecialchars($q['question']) ?>
</p>

<?php foreach (['a','b','c','d'] as $opt): ?>
<?php
$checked = $_SESSION['exam_answers'][$assessment_id][$q['id']] ?? '';
?>
<div class="form-check">
<input class="form-check-input"
type="radio"
name="answers[<?= $q['id'] ?>]"
value="<?= $opt ?>"
<?= ($checked === $opt) ? 'checked' : '' ?>>
<label class="form-check-label">
<?= strtoupper($opt) ?>. <?= htmlspecialchars($q['option_'.$opt]) ?>
</label>
</div>
<?php endforeach; ?>

</div>
</div>
<?php endforeach; ?>

<div class="d-flex justify-content-between">

<?php if ($page > 1): ?>
    <a href="?id=<?= $assessment_id ?>&page=<?= $page - 1 ?>" class="btn btn-secondary">
        ⬅ Previous
    </a>
<?php else: ?>
    <span></span>
<?php endif; ?>

<?php if ($page < $total_pages): ?>
    <button type="submit"
            formaction="?id=<?= $assessment_id ?>&page=<?= $page + 1 ?>"
            class="btn btn-primary">
        Next ➡
    </button>
<?php else: ?>
    <button type="submit"
            formaction="submit_assessment.php"
            class="btn btn-success">
        ✅ Submit Assessment
    </button>
<?php endif; ?>

</div>

<input type="hidden" name="assessment_id" value="<?= $assessment_id ?>">
</form>
</div>

</body>
</html>
