<?php
session_start();
date_default_timezone_set('Africa/Lagos'); // set your timezone
require_once "php/config.php";

$message = "";

if (!isset($_GET['token'])) {
    die("Invalid request");
}

$token = $_GET['token'];

// Verify token
$stmt = $pdo->prepare("SELECT id, token_expiry FROM users WHERE reset_token = ?");
$stmt->execute([$token]);
$user = $stmt->fetch();

if (!$user) {
    die("Token invalid");
}

// Check if token expired
if (strtotime($user['token_expiry']) < time()) {
    die("Token expired");
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $password = $_POST['password'];
    $confirm  = $_POST['confirm'];

    if ($password !== $confirm) {
        $message = "<div class='alert alert-danger'>Passwords do not match</div>";
    } elseif (strlen($password) < 6) {
        $message = "<div class='alert alert-danger'>Password too short</div>";
    } else {
        $hashed = password_hash($password, PASSWORD_DEFAULT);

        // Update password and clear token
        $update = $pdo->prepare("UPDATE users SET password = ?, reset_token = NULL, token_expiry = NULL WHERE id = ?");
        $update->execute([$hashed, $user['id']]);

        $message = "<div class='alert alert-success'>Password updated successfully. <a href='login.php'>Login</a></div>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Reset Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow">
                <div class="card-body">
                    <h4 class="text-center mb-3">Reset Password</h4>
                    <?= $message ?>
                    <form method="POST">
                        <div class="mb-3">
                            <label>New Password</label>
                            <input type="password" name="password" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Confirm Password</label>
                            <input type="password" name="confirm" class="form-control" required>
                        </div>
                        <button class="btn btn-success w-100">Reset Password</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
