<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
require_once 'Config.php';

$errors = [];
$old = ['fullname'=>'','email'=>''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fullname = trim($_POST['fullname'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';

    $old['fullname'] = $fullname;
    $old['email'] = $email;
    $old['password'] = $password;

    if ($fullname === '') $errors[] = 'Name is required.';
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Valid email is required.';
    if (strlen($password) < 6) $errors[] = 'Password must be at least 6 characters.';
    if ($password !== $password_confirm) $errors[] = 'Password confirmation does not match.';

    if (empty($errors)) {
        $stmt = $pdo->prepare('SELECT id FROM users WHERE email = :email LIMIT 1');
        $stmt->execute([':email' => $email]);
        if ($stmt->fetch()) {
            $errors[] = 'Email already registered. Try logging in.';
        } else {
            $pw_hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare('INSERT INTO users (fullname, email, password, role, created_at) VALUES (:fullname, :email, :password, :role, NOW())');
            $stmt->execute([
                ':fullname' => $fullname,
                ':email' => $email,
                ':password' => $pw_hash,
                ':role' => 'student'
            ]);
            $userId = $pdo->lastInsertId();
            $_SESSION['user'] = ['id' => $userId, 'fullname' => $fullname, 'email' => $email, 'role' => 'student'];
            header('Location: dashboard.php');
            exit;
        }
    }
}

require_once __DIR__ . '/includes/header.php';
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-lg border-0 rounded-4">
                <div class="card-body p-3">
                    <h3 class="card-title text-center mb-4">👩‍🎓 Student Registration</h3>

                    <?php if(!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach($errors as $e): ?>
                                <li><?=htmlspecialchars($e)?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <?php endif; ?>

                    <form method="post" novalidate>
                        <div class="mb-2">
                            <label class="form-label">Full Name</label>
                            <input type="text" name="fullname" class="form-control form-control rounded-3" value="<?=htmlspecialchars($old['fullname'])?>" required>
                        </div>

                        <div class="mb-2">
                            <label class="form-label">Email Address</label>
                            <input type="email" name="email" class="form-control form-control rounded-3" value="<?=htmlspecialchars($old['email'])?>" required>
                        </div>

                        <div class="mb-2">
                            <label class="form-label">Password</label>
                            <input type="password" name="password" class="form-control form-control rounded-3" required>
                        </div>

                        <div class="mb-2">
                            <label class="form-label">Confirm Password</label>
                            <input type="password" name="password_confirm" class="form-control form-control rounded-3" required>
                        </div>

                        <div class="d-grid gap-2">
                            <button class="btn btn-primary btn-lg rounded-3" type="submit">Create Account</button>
                            <a href="login.php" class="btn btn-outline-secondary btn-lg rounded-3">Already have an account? Login</a>
                        </div>
                    </form>
                </div>
            </div>
            <!--<p class="text-center mt-3 text-muted">&copy; <?=date('Y')?> Excellent Grade</p>-->
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
