<?php
session_start();
require_once 'Config.php';
header('Content-Type: application/json');

if(!isset($_SESSION['user'])){
    echo json_encode(['status'=>'error','message'=>'Not logged in']);
    exit;
}

$user_id = $_SESSION['user']['id'];
$course_id = $_POST['course_id'] ?? 0;
$comment = trim($_POST['comment'] ?? '');

if($comment==='' || $course_id==0){
    echo json_encode(['status'=>'error','message'=>'Invalid input']);
    exit;
}

$stmt = $pdo->prepare("INSERT INTO video_comments(user_id, course_id, comment) VALUES(:user_id, :course_id, :comment)");
$stmt->execute([':user_id'=>$user_id, ':course_id'=>$course_id, ':comment'=>$comment]);

echo json_encode([
    'status'=>'success',
    'fullname'=>$_SESSION['user']['fullname'],
    'comment'=>$comment,
    'created_at'=>date('Y-m-d H:i:s')
]);
