<?php
header('Content-Type: application/json');
require_once 'config.php';

$check = $pdo->prepare("SELECT id FROM subscriptions 
                        WHERE user_id=? AND course_id=? AND status='active'");
$check->execute([$user_id, $course_id]);

if($check->rowCount() > 0){
    echo json_encode([
        "status"=>"success",
        "message"=>"Already verified"
    ]);
    exit;
}


$reference = $_POST['reference'] ?? '';
$subscription_id = $_POST['subscription_id'] ?? '';

if (!$reference || !$subscription_id) {
    echo json_encode(["status"=>"error","message"=>"Invalid data"]);
    exit;
}

// Paystack secret key
$secret_key = 'sk_test_b1685f14b9c45266989ea5cacad076c5053f45ad';

// cURL setup
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . urlencode($reference),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $secret_key",
        "Cache-Control: no-cache"
    ],
    CURLOPT_SSL_VERIFYPEER => false, // ✅ disable SSL verification for localhost (dev)
]);
$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo json_encode(["status"=>"error","message"=>"cURL Error: $err"]);
    exit;
}

$result = json_decode($response, true);

$result = json_decode($response, true);
file_put_contents("paystack_debug.txt", print_r($result, true), FILE_APPEND);


// Check payment success
if (isset($result['status']) && $result['status'] && $result['data']['status'] === 'success') {
    
    $stmt = $pdo->prepare("
        UPDATE subscriptions 
        SET payment_status = 'paid',
            paid_at = NOW(),
            payment_method = 'paystack'
            WHERE reference=:reference
        
    ");

    // WHERE id = :id
//     UPDATE subscriptions 
// SET payment_status='paid',
// paid_at=NOW(),
// payment_method='paystack'




    $stmt->execute([
        // 'id' => $subscription_id
    'reference' => $reference
    ]);

    echo json_encode(["status"=>"success","message"=>"Payment successful! Subscription activated."]);
} else {
    $message = $result['data']['gateway_response'] ?? 'Payment failed or not verified';
    echo json_encode(["status"=>"error","message"=>$message]);
}
