<?php
header('Content-Type: application/json');
require_once 'config.php';

$subscription_id = $_POST['subscription_id'] ?? '';

if (!$subscription_id) {
    echo json_encode(["status"=>"error","message"=>"Invalid subscription ID"]);
    exit;
}

// Update manual payment as paid
$stmt = $pdo->prepare("
    UPDATE subscriptions 
    SET payment_status = 'paid',
        paid_at = NOW(),
        payment_method = 'manual'
    WHERE id = :id
");
if($stmt->execute(['id'=>$subscription_id])){
    echo json_encode(["status"=>"success","message"=>"Manual payment verified. Subscription active."]);
}else{
    echo json_encode(["status"=>"error","message"=>"Failed to verify manual payment."]);
}
