<?php
header('Content-Type: application/json');
require_once 'config.php';

// Collect POST data
$email      = $_POST['email'] ?? '';
$course_id  = $_POST['course_id'];
$duration   = $_POST['duration'] ?? 30;
$plan       = $_POST['plan'] ?? regular; // regular or premium
$reference = $_POST['reference'] ?? ''; // get reference from JS
$payment_method = $_POST['payment_method'] ?? 'paystack'; // paystack or manual

if (!$email || !$course_id) {
    echo json_encode(["error" => "Invalid data"]);
    exit;
}



// ===================================
// 1. GET COURSE FROM DATABASE
// ===================================
$stmt = $pdo->prepare('SELECT * FROM courses WHERE id = :course_id');
$stmt->execute(['course_id' => $course_id]);
$course = $stmt->fetch();




if (!$course) {
    echo json_encode(["error" => "Course not found"]);
    exit;
}

$basePrice = floatval($course['price']); // REAL DATABASE PRICE


// ===================================
// 2. CALCULATE PRICE SECURELY
// ===================================
$amount = ($plan === "premium") ? ($basePrice * 2) : $basePrice;


// ===================================
// 3. GET OR CREATE USER
// ===================================
$stmt = $pdo->prepare('SELECT id FROM users WHERE email = :email');
$stmt->execute(['email' => $email]);
$user = $stmt->fetch();


if (!$user) {
    // Create new user
    $stmt = $pdo->prepare('INSERT INTO users (email) VALUES (:email)');
    $stmt->execute(['email' => $email]);
    $user_id = $pdo->lastInsertId();
} else {
    $user_id = $user['id'];
}


// ===================================
// 4. CREATE SUBSCRIPTION (pending payment)
// ===================================
$start_date = date('Y-m-d');
$end_date   = date('Y-m-d', strtotime($start_date . ' + ' . $duration . ' days'));

$payment_status = ($payment_method === "manual") ? "pending_manual" : "pending";


$stmt = $pdo->prepare('INSERT INTO subscriptions 
    (user_id, course_id, plan, amount, reference, start_date, end_date, payment_status, payment_method) 
    VALUES 
    (:user_id, :course_id, :plan, :amount, :reference, :start_date, :end_date, :payment_status, :payment_method)'
);

$stmt->execute([
    'user_id'       => $user_id,
    'course_id'     => $course_id,
    'plan'          => $plan,
    'amount'        => $amount,
    'reference'     => $reference,
    'start_date'    => $start_date,
    'end_date'      => $end_date,
    'payment_status'=> $payment_status, // e.g., 'pending'
    'payment_method'=> $payment_method
]);


$subscription_id = $pdo->lastInsertId();


// ===================================
// 5. RETURN RESPONSE TO JAVASCRIPT
// ===================================
echo json_encode([
    'subscription_id' => $subscription_id,
    'amount'          => $amount,
    'email'           => $email,
    'plan'            => $plan,
    'payment_method'  => $payment_method
]);
?>
