<?php
ob_clean(); // remove any previous output
error_reporting(0);
error_reporting(E_ALL);
ini_set("display_errors", 1);

header('Content-Type: application/json');
require_once 'config.php';
// session_start();

// ======================
// 1. COLLECT POST DATA
// ======================
$email          = $_POST['email'] ?? '';
$course_id      = $_POST['course_id'] ?? null;
$plan           = $_POST['plan'] ?? 'regular'; // regular, premium, daily, weekly, monthly, yearly
$number         = (int)($_POST['number'] ?? 1); // number of units (days/weeks/months/years)
$reference      = $_POST['reference'] ?? ''; 
$payment_method = $_POST['payment_method'] ?? 'paystack'; 

// if (!$email || !$course_id) {
//     echo json_encode([
//         "error" => "Invalid data",
//         "email" => $email,
//         "course_id" => $course_id,
//         "post" => $_POST
//     ]);
//     exit;
// }

if (!$email || !$course_id) {
    echo json_encode(["error" => "Invalid data"]);
    exit;
}



// ======================
// 2. GET COURSE FROM DB
// ======================
$stmt = $pdo->prepare('SELECT * FROM courses WHERE id = :course_id');
$stmt->execute(['course_id' => $course_id]);
$course = $stmt->fetch();

if (!$course) {
    echo json_encode(["error" => "Course not found"]);
    exit;
}

$basePrice = floatval($course['price']); // real course price

// ======================
// 3. CALCULATE PRICE
// ======================
// Premium doubles price
if ($plan === "premium") {
    $amount = $basePrice * 2;
} else {
    $amount = $basePrice;
}

// ======================
// 4. GET OR CREATE USER
// ======================
$stmt = $pdo->prepare('SELECT id FROM users WHERE email = :email');
$stmt->execute(['email' => $email]);
$user = $stmt->fetch();

if (!$user) {
    $stmt = $pdo->prepare('INSERT INTO users (email) VALUES (:email)');
    $stmt->execute(['email' => $email]);
    $user_id = $pdo->lastInsertId();
} else {
    $user_id = $user['id'];
}

// ======================
// 5. CALCULATE START & EXPIRY
// ======================
$start_date = date('Y-m-d H:i:s');
$expiry = $start_date; // default

// If duration (days) is sent (old logic)
if (isset($_POST['duration'])) {
    $days = intval($_POST['duration']);
    $expiry = date('Y-m-d H:i:s', strtotime("+$days days"));
} else {
    // New logic: number + plan
    switch($plan){
        case 'daily':   $expiry = date('Y-m-d H:i:s', strtotime("+$number days")); break;
        case 'weekly':  $expiry = date('Y-m-d H:i:s', strtotime("+$number weeks")); break;
        case 'monthly': $expiry = date('Y-m-d H:i:s', strtotime("+$number months")); break;
        case 'yearly':  $expiry = date('Y-m-d H:i:s', strtotime("+$number years")); break;
        default:        $expiry = date('Y-m-d H:i:s', strtotime("+30 days")); break; // fallback
    }
}

// Payment status
$payment_status = ($payment_method === "manual") ? "pending_manual" : "pending";

$stmt = $pdo->prepare("SELECT id FROM subscriptions WHERE reference = :reference");
$stmt->execute(['reference'=>$reference]);

if($stmt->rowCount() > 0){
    echo json_encode(["error"=>"Duplicate transaction"]);
    exit;
}

// CHECK IF ALREADY SUBSCRIBED
$check = $pdo->prepare("SELECT id FROM subscriptions 
                        WHERE user_id=? AND course_id=? AND status='active'");
$check->execute([$user_id, $course_id]);

if($check->rowCount() > 0){
    echo json_encode([
        "status"=>"exists",
        "message"=>"Already subscribed"
    ]);
    exit;
}

// ======================
// 6. SAVE SUBSCRIPTION
// ======================
// Check if table has both old (duration) and new (number + expiry) fields
try {
    $stmt = $pdo->prepare('INSERT INTO subscriptions 
        (user_id, course_id, plan, number, amount, reference, start_date, end_date, payment_status, payment_method, created_at) 
        VALUES 
        (:user_id, :course_id, :plan, :number, :amount, :reference, :start_date, :end_date, :payment_status, :payment_method, NOW())'
    );

    $stmt->execute([
        'user_id'       => $user_id,
        'course_id'     => $course_id,
        'plan'          => $plan,
        'number'        => $number,
        'amount'        => $amount,
        'reference'     => $reference,
        'start_date'    => $start_date,
        'end_date'      => $expiry,
        'payment_status'=> $payment_status,
        'payment_method'=> $payment_method
    ]);
} catch (Exception $e) {
    echo json_encode([
        "error" => "DB Error",
        "message" => $e->getMessage()
    ]);
    exit;
}

$subscription_id = $pdo->lastInsertId();

// ======================
// 7. RETURN RESPONSE
// ======================
echo json_encode([
    'success'         => true,
    'subscription_id' => $subscription_id,
    'amount'          => $amount,
    'plan'            => $plan,
    'number'          => $number,
    'expiry'          => $expiry,
    'email'           => $email,
    'payment_method'  => $payment_method
]);


?>
