<?php
session_start();
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: ../contact.php");
    exit;
}

$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$subject = trim($_POST['subject'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$message = trim($_POST['message'] ?? '');

if (!$name || !$email || !$subject || !$phone || !$message) {
    $_SESSION['contact_error'] = "All fields are required.";
    header("Location: ../contact.php");
    exit;
}

$stmt = $pdo->prepare("
    INSERT INTO contact_messages (name, email, subject, phone, message)
    VALUES (:name, :email, :subject, :phone, :message)
");

$stmt->execute([
    'name' => $name,
    'email' => $email,
    'subject' => $subject,
    'phone' => $phone,
    'message' => $message
]);

$_SESSION['contact_success'] = "Your message has been sent successfully.";
header("Location: ../contact.php");
exit;
