<?php
require_once 'config.php';

// Make sure the request actually sent course_id
if (!isset($_POST['course_id'])) {
    header("Content-Type: application/json");
    echo json_encode([]); // return empty array
    exit;
}

$course_id = intval($_POST['course_id']); // ensure it's a number

// Fetch modules for this course
$stmt = $pdo->prepare("SELECT * FROM course_modules WHERE course_id = ? ORDER BY module_order ASC");
$stmt->execute([$course_id]);

$modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

// AUTO MAKE FIRST MODULE FREE
if (count($modules) > 0) {
    $modules[0]['is_free'] = 1;
}

// Return JSON ONLY
header("Content-Type: application/json");
echo json_encode($modules);
exit;
