<?php
require_once 'config.php';

if (!isset($_POST['category_id'])) {
    echo json_encode([
        "courses" => [],
        "total_pages" => 0
    ]);
    exit;
}

$category_id = (int)$_POST['category_id'];
$limit = isset($_POST['limit']) ? (int)$_POST['limit'] : 4;
$page  = isset($_POST['page']) ? (int)$_POST['page'] : 1;

if ($page < 1) $page = 1;
$offset = ($page - 1) * $limit;

/* Count total courses */
$countStmt = $pdo->prepare(
    "SELECT COUNT(*) FROM courses WHERE category_id = ?"
);
$countStmt->execute([$category_id]);
$total = $countStmt->fetchColumn();
$total_pages = ceil($total / $limit);

/* Fetch courses */
$stmt = $pdo->prepare(
    "SELECT * FROM courses
     WHERE category_id = ?
     ORDER BY id DESC
     LIMIT $limit OFFSET $offset"
);
$stmt->execute([$category_id]);
$courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* Return JSON */
echo json_encode([
    "courses" => $courses,
    "total_pages" => $total_pages
]);
