<?php
session_start();
require_once "config.php";

$user_id = $_SESSION['user']['id'];
$category_id = $_GET['category_id'];

// total videos
$totalStmt = $pdo->prepare("
    SELECT COUNT(*) FROM courses WHERE category_id = ?
");
$totalStmt->execute([$category_id]);
$totalVideos = $totalStmt->fetchColumn();

// watched videos
$watchedStmt = $pdo->prepare("
    SELECT COUNT(DISTINCT vp.video_id)
    FROM video_progress vp
    INNER JOIN courses c ON c.id = vp.course_id
    WHERE vp.user_id = ? AND c.category_id = ? AND vp.watched = 1
");
$watchedStmt->execute([$user_id, $category_id]);
$watchedVideos = $watchedStmt->fetchColumn();

if ($totalVideos > 0 && $watchedVideos == $totalVideos) {
    echo json_encode(["completed" => true]);
} else {
    echo json_encode([
        "completed" => false,
        "progress" => "$watchedVideos / $totalVideos"
    ]);
}
