<?php
session_start();
require_once 'php/config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user'], $_POST['course_id'], $_POST['type'])) {
    echo json_encode(['status' => 'error']);
    exit;
}

$user_id   = (int) $_SESSION['user']['id'];
$course_id = (int) $_POST['course_id'];
$type      = $_POST['type']; // 10min | 5min | end

if (!in_array($type, ['10min', '5min', 'end'])) {
    echo json_encode(['status' => 'error']);
    exit;
}

try {

    // 1️⃣ Attendance table (NO DUPLICATES)
    $stmt = $pdo->prepare("
        INSERT INTO live_class_attendance 
            (user_id, course_id, warned_10min, warned_5min, stayed_till_end)
        VALUES 
            (:uid, :cid,
             IF(:type='10min',1,0),
             IF(:type='5min',1,0),
             IF(:type='end',1,0))
        ON DUPLICATE KEY UPDATE
            warned_10min    = warned_10min OR VALUES(warned_10min),
            warned_5min     = warned_5min  OR VALUES(warned_5min),
            stayed_till_end = stayed_till_end OR VALUES(stayed_till_end)
    ");

    $stmt->execute([
        'uid'  => $user_id,
        'cid'  => $course_id,
        'type' => $type
    ]);

    // 2️⃣ Logs table (NO DUPLICATES)
    $log = $pdo->prepare("
        INSERT IGNORE INTO live_class_logs (user_id, course_id, action)
        VALUES (:uid, :cid, :action)
    ");

    $log->execute([
        'uid'    => $user_id,
        'cid'    => $course_id,
        'action' => $type
    ]);

    echo json_encode(['status' => 'success']);

} catch (PDOException $e) {
    echo json_encode(['status' => 'error']);
}
