<?php
session_start();
require_once 'php/config.php';

$errors = [];
$redirect = 'dashboard.php';

if (!empty($_GET['redirect'])) $redirect = ltrim($_GET['redirect'], '/');
if (!empty($_POST['redirect'])) $redirect = ltrim($_POST['redirect'], '/');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Enter a valid email.';
    if ($password === '') $errors[] = 'Enter password.';

    if (empty($errors)) {
        try {
            $stmt = $pdo->prepare('SELECT id, fullname, email, password, role FROM users WHERE email = :email LIMIT 1');
            $stmt->execute([':email' => $email]);
            $user = $stmt->fetch();

            if ($user && password_verify($password, $user['password'])) {
                $_SESSION['user'] = [
                    'id' => $user['id'],
                    'fullname' => $user['fullname'],
                    'email' => $user['email'],
                    'role' => $user['role']
                ];
                header('Location: ' . $redirect);
                exit;
            } else {
                $errors[] = 'Invalid email or password.';
            }
        } catch (PDOException $e) {
            $errors[] = 'Database error: ' . $e->getMessage();
        }
    }
}

require_once __DIR__ . '/includes/header.php';
?>

<div class="d-flex justify-content-center align-items-center" style="min-height: 80vh;">
  <div class="card shadow-sm p-4 rounded-4" style="width: 100%; max-width: 400px;">
    <h3 class="text-center mb-4 fw-bold"> Students Login</h3>

    <?php if(!empty($errors)): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach($errors as $e): ?>
            <li><?=htmlspecialchars($e)?></li>
          <?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post">
      <input type="hidden" name="redirect" value="<?=htmlspecialchars($redirect)?>">

      <div class="mb-3">
        <label class="form-label fw-semibold">Email</label>
        <input type="email" name="email" class="form-control form-control-lg rounded-3" placeholder="you@example.com" required>
      </div>

      <div class="mb-3">
        <label class="form-label fw-semibold">Password</label>
        <input type="password" name="password" class="form-control form-control-lg rounded-3" placeholder="Enter your password" required>
      </div>

      <div class="d-grid gap-2 mt-3">
        <button class="btn btn-primary btn-lg rounded-3" type="submit">Login</button>
        <a href="register.php" class="btn btn-outline-secondary btn-lg rounded-3">Create Account</a>
      </div>
    </form>

    <p class="text-center small mt-3 text-muted">
      Forgot password? <a href="forgot_password.php" class="text-decoration-none">Reset here</a>.
    </p>
  </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
