// =======================
// GLOBAL STATE
// =======================
let selectedCategoryId = null;
let currentVideo = null;
let currentModuleId = null;

// =======================
// PAGINATION STATE
// =======================
let currentPage = 1;
const COURSES_PER_PAGE = 4;
let totalPages = 1;

// =======================
// PLAN PRICES
// =======================
const PLAN_PRICES = {
  regular: 3000,
  premium: 7000
};

// =======================
// LOAD MODULES
// =======================
function loadModules(courseId) {
  fetch("php/fetch_modules.php", {
    method: "POST",
    headers: {"Content-Type":"application/x-www-form-urlencoded"},
    // body: `course_id=${courseId}`
    body:"course_id="+courseId
  })
  .then(res => res.json())
  .then(data => {
    const box = document.getElementById(`modulesBox_${courseId}`);
    box.innerHTML = "";

    data.forEach(m => {
      let status = m.is_free == 1 ? "Free" : "Locked";

      box.innerHTML += `
        <div class="module-item">
          ${m.title} - ${status}
          <button onclick="playModule(${m.id},${m.is_free}, ${m.course_id})">
            Play
          </button>
        </div>
      `;
    });
  });
}

// =======================
// PLAY MODULE
// =======================
function playModule(moduleId, isFree, courseId) {
  if (isFree == 1) {
    openVideo(moduleId, courseId);
  } else {
    showSubscribePrompt(courseId);
  }
}

// =======================
// OPEN VIDEO
// =======================
function openVideo(moduleId, courseId) {
  fetch(`php/get_module.php?id=${moduleId}`)
    .then(res => res.json())
    .then(module => {
      const video = document.getElementById("mainVideo");
      video.src = `courses/${module.video_file}`;
      video.dataset.moduleId = moduleId;
      video.dataset.courseId = courseId;
      video.play();
      setupVideoProtection(video);
    });
}

// =======================
// LOAD CATEGORIES
// =======================
fetch("php/fetch_categories.php")
  .then(res => res.json())
  .then(categories => {
    const wrapper = document.getElementById("categories");
    categories.forEach(cat => {
      const div = document.createElement("div");
      div.classList.add("category-item");
      div.textContent = cat.name;
      div.dataset.id = cat.id;

      div.onclick = () => {
        document.querySelectorAll(".category-item").forEach(el => el.classList.remove("selected"));
        div.classList.add("selected");
        selectedCategoryId = cat.id;
        localStorage.setItem("selectedCategoryId", cat.id);
        fetchCourses(cat.id);
      };

      wrapper.appendChild(div);
    });
  })
  .catch(err => console.error(err));

// =======================
// FETCH COURSES
// =======================
function fetchCourses(category_id, page = 1) {
  currentPage = page;
  localStorage.setItem("selectedCategoryId", category_id);
  localStorage.setItem("currentPage", currentPage);

  fetch("php/fetch_courses.php", {
    method: "POST",
    headers: {"Content-Type": "application/x-www-form-urlencoded"},
    body: new URLSearchParams({category_id, page, limit: COURSES_PER_PAGE})
  })
  .then(res => res.json())
  .then(data => {
    const wrapper = document.getElementById("courses");
    wrapper.innerHTML = "";
    const courses = data.courses;
    totalPages = data.total_pages;

    courses.forEach(course => {
      const div = document.createElement("div");
      div.classList.add("course-item");

      div.innerHTML = `
        <div>
          <video width="200" controls poster="assets/uploads/${course.thumbnail || 'default.jpg'}">
            <source src="courses/${course.file}" type="video/mp4">
          </video>
          <br>
          <strong>${course.name}</strong><br>
          Level: ${course.level}<br>
          Description: ${course.description}<br>
          Duration: ${course.duration} days<br>
          Price: ₦${course.price}<br>
          <button onclick="loadModules(${course.id})">View Modules</button>
<div id="modulesBox_${course.id}"></div>

        </div>
        <button class="subscribe-btn" onclick="subscribe(${course.id}, ${course.price}, '${course.name.replace(/'/g, "\\'")}')">
          Subscribe
        </button>
        <button class="btn-btn" onclick="loadModules(${course.id})">View Modules</button>
<button onclick="playModule(module.id, module.is_free, module.course_id)">Play</button>

      `;

      wrapper.appendChild(div);
      setupVideoProtection(div.querySelector("video"));
    });

    renderPagination();
    checkCertificate();
  })
  .catch(err => console.error(err));
}

// =======================
// PAGINATION
// =======================
function renderPagination() {
  const container = document.getElementById("pagination");
  if (!container) return;

  container.innerHTML = "";

  if (currentPage > 1) container.innerHTML += `<button onclick="fetchCourses(${selectedCategoryId}, ${currentPage-1})">⬅ Prev</button>`;

  for (let i = 1; i <= totalPages; i++) {
    container.innerHTML += `<button onclick="fetchCourses(${selectedCategoryId}, ${i})" style="font-weight:${i===currentPage?'bold':'normal'}">${i}</button>`;
  }

  if (currentPage < totalPages) container.innerHTML += `<button onclick="fetchCourses(${selectedCategoryId}, ${currentPage+1})">Next ➡</button>`;
}

// =======================
// VIDEO PROTECTION
// =======================
function setupVideoProtection(video) {
  if (!video) return;

  let lastTime = 0;
  let previewEnded = false;
  const PREVIEW_DURATION = 60;

  video.addEventListener("contextmenu", e => e.preventDefault());
  video.setAttribute("controlsList", "nodownload");
  video.addEventListener("dragstart", e => e.preventDefault());

  document.addEventListener("visibilitychange", () => { if(document.hidden) video.pause(); });

  video.addEventListener("timeupdate", () => {
    if(video.currentTime >= PREVIEW_DURATION && !previewEnded) {
      previewEnded = true;
      video.pause();
      video.currentTime = PREVIEW_DURATION;
      showSubscribePrompt(video.dataset.courseId);
    }

    if(!previewEnded && video.currentTime > lastTime + 0.5) video.currentTime = lastTime;
    else lastTime = video.currentTime;
  });

  video.addEventListener("ended", () => {
    if(!previewEnded) {
      markVideoWatched(video.dataset.moduleId);
      checkCertificate();
    }
  });
}

// =======================
// MARK VIDEO WATCHED
// =======================
function markVideoWatched(moduleId) {
  fetch("php/mark_video_watched.php", {
    method:"POST",
    headers: {"Content-Type":"application/x-www-form-urlencoded"},
    body: `module_id=${moduleId}`
  });
}

// =======================
// RESTORE CATEGORY
// =======================
window.addEventListener("DOMContentLoaded", () => {
  const savedCategoryId = localStorage.getItem("selectedCategoryId");
  if(savedCategoryId) {
    selectedCategoryId = savedCategoryId;
    const categories = document.querySelectorAll(".category-item");
    categories.forEach(catDiv => {
      if(catDiv.dataset.id == savedCategoryId) catDiv.classList.add("selected");
    });
    fetchCourses(savedCategoryId, currentPage);
  }
});

// =======================
// SUBSCRIPTION
// =======================
function subscribe(course_id, coursePrice, courseName) {
  const box = document.getElementById("subscriptionForm");
  if(!box) return;

  box.innerHTML = `<h3>Subscribe to ${courseName}</h3> ...`; // keep your subscription form here
  // your plan selection, manual/paystack logic remains the same, just ensure:
  // - plan price calculation is correct
  // - Paystack key is correct
  // - manual reference shows properly
  // - redirect: window.location.href = "live_classes.php";
}

// =======================
// CERTIFICATE
// =======================
function checkCertificate() {
  if(!selectedCategoryId) return;
  fetch(`php/check_certificate.php?category_id=${selectedCategoryId}`)
    .then(res => res.json())
    .then(data => {
      if(data.completed) document.getElementById("certificateBox").innerHTML = `<a href="php/generate_certificate.php?category_id=${selectedCategoryId}" class="btn btn-success">🎓 Download Certificate</a>`;
    });
}
