// =======================
// GLOBAL STATE
// =======================

let selectedCategoryId = null;
let currentVideo = null;


// =======================
// PAGINATION STATE
// =======================
let currentPage = 1;
const COURSES_PER_PAGE = 4; // change to 6, 8, etc
let totalPages = 1;


// =======================
// PLAN PRICES
// =======================
const PLAN_PRICES = {
  regular: 3000,   // ₦3,000
  premium: 7000    // ₦7,000
};


//=======================
// Fetch Modules
//=======================

function loadModules(courseId){
 fetch("php/fetch_modules.php",{
  method:"POST",
  headers:{"Content-Type":"application/x-www-form-urlencoded"},
  body:"course_id="+courseId
 })
 .then(res=>res.json())
 .then(data=>{
   let box=document.getElementById("modulesBox");
   box.innerHTML="";

   data.forEach(m=>{
     let status=m.is_free==1?"Free":"Locked";

     box.innerHTML+=`
      <div>
       ${m.title} - ${status}
       <button onclick="playModule(${m.id},${m.is_free})">Play</button>
      </div>`;
   });
 });
}

// play Module
function playModule(id,isFree){
 if(isFree==1){
   openVideo(id);
 }else{
   alert("Please subscribe to continue");
 }
}

// LOad Module
function openVideo(id){
 fetch("php/get_module.php?id="+id)
 .then(res=>res.json())
 .then(m=>{
  document.getElementById("mainVideo").src="courses/"+m.video_file;
 });
}

document.getElementById("mainVideo").addEventListener("ended",()=>{
 alert("Module completed");
});




// =======================
// Load Categories
// =======================
fetch("php/fetch_categories.php")
  .then(res => res.json())
  .then(categories => {
    const wrapper = document.getElementById("categories");

    categories.forEach(cat => {
      const div = document.createElement("div");
      div.classList.add("category-item");
      div.textContent = cat.name;
      div.dataset.id = cat.id; // store category ID

      div.onclick = () => {
        document.querySelectorAll(".category-item")
          .forEach(el => el.classList.remove("selected"));

        div.classList.add("selected"); 
        selectedCategoryId = cat.id;

         // ✅ Save the selected category ID in localStorage
    localStorage.setItem("selectedCategoryId", cat.id);

        fetchCourses(cat.id);
      };

      wrapper.appendChild(div);
    });
  })
  .catch(err => console.log("Error:", err));


// =======================
// Fetch Courses
// =======================
function fetchCourses(category_id, page = 1) {
  currentPage = page;

  localStorage.setItem("selectedCategoryId", category_id);
  localStorage.setItem("currentPage", currentPage);

  fetch("php/fetch_courses.php", {
    method: "POST",
    headers: {"Content-Type": "application/x-www-form-urlencoded"},
    body: new URLSearchParams({
      category_id,
      page,
      limit: COURSES_PER_PAGE
    })
  })
  .then(res => res.json())
  .then(data => {

const courses = data.courses;
totalPages = data.total_pages;


    const wrapper = document.getElementById("courses");
    wrapper.innerHTML = "";

    courses.forEach(course => {
      const div = document.createElement("div");
      div.classList.add("course-item");

      div.innerHTML = `
        <div>
          <video width="200" controls poster="assets/uploads/${course.thumbnail || 'default.jpg'}">
            <source src="courses/${course.file}" type="video/mp4">
          </video>

          <br>
          <strong>${course.name}</strong><br>
          Level: ${course.level}<br>
          Description: ${course.description}<br>
          Duration: ${course.duration} days<br>
          Price: ₦${course.price}<br>
        </div>

        <button class="subscribe-btn"
          onclick="subscribe(${course.id}, ${course.price}, '${course.name.replace(/'/g, "\\'")}')">
          Subscribe
        </button>
      `;

      wrapper.appendChild(div);

      const video = div.querySelector("video");
      setupVideoProtection(video, course.id);
    });

    renderPagination();
    checkCertificate();
  })
  .catch(err => console.log("Error:", err));
}

// =======================
// PAGINATION UI RENDER FUNCTION
// =======================

function renderPagination() {
  const container = document.getElementById("pagination");
  if (!container) return;

  container.innerHTML = "";

  // Previous
  if (currentPage > 1) {
    container.innerHTML += `
      <button onclick="fetchCourses(${selectedCategoryId}, ${currentPage - 1})">
        ⬅ Prev
      </button>
    `;
  }

  // Page numbers
  for (let i = 1; i <= totalPages; i++) {
    container.innerHTML += `
      <button
        onclick="fetchCourses(${selectedCategoryId}, ${i})"
        style="font-weight:${i === currentPage ? 'bold' : 'normal'}"
      >
        ${i}
      </button>
    `;
  }

  // Next
  if (currentPage < totalPages) {
    container.innerHTML += `
      <button onclick="fetchCourses(${selectedCategoryId}, ${currentPage + 1})">
        Next ➡
      </button>
    `;
  }
}


// =======================
// PREVENT VIDEO SKIPPING
// =======================

function setupVideoProtection(video, courseId) {
  if (!video) return;

  let lastTime = 0;
  let previewEnded = false;
  const PREVIEW_DURATION = 60;

  // 🚫 Disable right-click
  video.addEventListener("contextmenu", e => e.preventDefault());

  // 🚫 Disable download
  video.setAttribute("controlsList", "nodownload");

  // 🚫 Prevent dragging
  video.addEventListener("dragstart", e => e.preventDefault());

  // ⏸ Pause on tab switch
  document.addEventListener("visibilitychange", () => {
    if (document.hidden) video.pause();
  });

  // 🔐 BLOCK PLAY AFTER PREVIEW
  video.addEventListener("play", () => {
    if (previewEnded) {
      video.pause();
      video.currentTime = PREVIEW_DURATION;
      showSubscribePrompt(courseId);
    }
  });

  // ⏩ Time enforcement
  video.addEventListener("timeupdate", () => {

    // 🔒 Stop at preview limit
    if (video.currentTime >= PREVIEW_DURATION && !previewEnded) {
      previewEnded = true;
      video.pause();
      video.currentTime = PREVIEW_DURATION;
      showSubscribePrompt(courseId);
      return;
    }

    // 🚫 Prevent skipping forward
    if (!previewEnded) {
      if (video.currentTime > lastTime + 0.5) {
        video.currentTime = lastTime;
      } else {
        lastTime = video.currentTime;
      }
    }
  });

  // ✅ Only mark as watched if fully allowed
  video.addEventListener("ended", () => {
    if (!previewEnded) {
      markVideoWatched(courseId);
      checkCertificate();
    }
  });
}



// ✅ Restore selected category on page reload


  
// On page load, restore selected category
window.addEventListener("DOMContentLoaded", () => {
    const savedCategoryId = localStorage.getItem("selectedCategoryId");
    if (savedCategoryId) {
        selectedCategoryId = savedCategoryId;

        // Add "selected" class to the right category
        const categories = document.querySelectorAll(".category-item");
        categories.forEach(catDiv => {
            if (catDiv.dataset.id == savedCategoryId) {
                catDiv.classList.add("selected");
            }
        });

        // Automatically fetch courses for the saved category
        fetchCourses(savedCategoryId, currentPage);
    }
});

function showSubscribePrompt(courseId) {
  const box = document.getElementById("subscriptionForm");
  if (!box) return;

  // Fetch course price from DB
  fetch("php/get_course.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `course_id=${courseId}`
  })
  .then(res => res.json())
  .then(course => {
    if (!course || !course.price || !course.name) {
      alert("Unable to load course price");
      return;
    }

    box.innerHTML = `
      <div style="
        background:#fff;
        padding:20px;
        border:2px solid #007bff;
        border-radius:8px;
        max-width:420px;
      ">
        <h4></h4>

      <h5 style="font-weight:600; margin-bottom:8px;">
          📘 ${course.name}
        </h5>

        <p>Subscribe to continue with the course.</p>

        <h5 class="text-primary mb-3">
          ₦${Number(course.price).toLocaleString()}
        </h5>

        <button id="subscribeBtn" class="btn btn-primary w-100">
          Subscribe Now
        </button>

        <button id="cancelBtn" class="btn btn-outline-secondary w-100 mt-2">
          Cancel
        </button>
      </div>
    `;

    document.getElementById("subscribeBtn").onclick = () => {
      subscribe(courseId, course.price,course.name);
    };

    document.getElementById("cancelBtn").onclick = () => {
      box.innerHTML = "";
    };
  })
  .catch(err => {
    console.error("Course fetch error:", err);
  });
}


// =======================
// MARK VIDEO WATCHED
// =======================
function markVideoWatched(course_id) {
  fetch("php/mark_video_watched.php", {
    method: "POST",
    headers: {"Content-Type": "application/x-www-form-urlencoded"},
    body: `course_id=${course_id}`
  });
}

// =======================
// CHECK CERTIFICATE
// =======================
function checkCertificate() {
  if (!selectedCategoryId) return;

  fetch(`php/check_certificate.php?category_id=${selectedCategoryId}`)
    .then(res => res.json())
    .then(data => {
      if (data.completed) {
        document.getElementById("certificateBox").innerHTML = `
          <a href="php/generate_certificate.php?category_id=${selectedCategoryId}"
             class="btn btn-success">
            🎓 Download Certificate
          </a>
        `;
      }
    });
}

// =======================
// Subscribe Form
// =======================
function subscribe(course_id, coursePrice, courseName) {
  const box = document.getElementById("subscriptionForm");

  box.innerHTML = `
    <h3>Subscribe to Course</h3>

<h5 style="font-weight:600; margin-bottom:8px;">
  📘 ${courseName}
</h5>

    <form id="subForm">
      <input type="hidden" name="course_id" value="${course_id}">
      <input type="hidden" name="amount" id="planAmount">
      <input type="hidden" name="payment_method" id="paymentMethod" value="paystack">

      <label>Email:</label>
      <input type="email" name="email" required>

      <label>Subscription Plan:</label>
      <select name="plan" id="planSelect" required>
        <option value="regular">Regular (Basic Access)</option>
        <option value="premium">Premium (Full Access)</option>
      </select>
 

      <p id="priceDisplay" style="margin-top:10px; font-weight:bold;"></p>

      <label>Duration:</label>
      <select name="duration" id="durationSelect">
        <option value="30">30 days</option>
        <option value="60">60 days</option>
        <option value="90">90 days</option>
      </select>

      <label>Payment Method:</label>
      <select name="payment_method_select" id="paymentMethodSelect">
        <option value="paystack">Pay Online (Paystack)</option>
        <option value="manual">Manual Bank Transfer</option>
      </select>

      <div id="manualInfo" style="display:none; margin-top:10px;"></div>

      <br><br>
      <button type="submit">Subscribe Now</button>
      <button type="button" id="closeForm">Close</button>
    </form>
  `;

  const planSelect = document.getElementById("planSelect");
  const amountField = document.getElementById("planAmount");
  const priceDisplay = document.getElementById("priceDisplay");
  const form = document.getElementById("subForm");
  const paymentMethodSelect = document.getElementById("paymentMethodSelect");
  const paymentMethodField = document.getElementById("paymentMethod");
  const manualInfo = document.getElementById("manualInfo");
  const closeFormBtn = document.getElementById("closeForm");

  closeFormBtn.onclick = () => box.innerHTML = "";

  function updatePrice() {
    let amount = coursePrice;
    if (planSelect.value === "premium") amount *= 2;
    amountField.value = amount;
    priceDisplay.textContent = "Price: ₦" + amount.toLocaleString();
  }
  updatePrice();
  planSelect.addEventListener("change", updatePrice);

  // Temporary reference for manual before submission
  let tempReference = 'TEMP_' + Math.floor(Math.random() * 1000000 + 1);

  // Toggle manual info
  paymentMethodSelect.addEventListener("change", () => {
    const method = paymentMethodSelect.value;
    paymentMethodField.value = method;

    if (method === "manual") {
      manualInfo.style.display = "block";
      manualInfo.innerHTML = `
        <div style="padding:10px; background:#f9f9f9; border:1px solid #ddd;">
          <strong>Bank Account Details:</strong><br>
          Bank: GTBank<br>
          Account Name: Your School Name<br>
          Account Number: 0123456789<br><br>
          <div style="background:#e6ffe6; padding:10px; border-left:4px solid green;">
            Manual payment selected. Your reference will appear after submitting.
          </div>
          <div style="color:green; font-size:18px; font-weight:bold; margin-top:10px;">
            Temporary Reference: ${tempReference}
          </div>
          <button type="button" id="verifyManualBtn" style="display:none; margin-top:10px;">
            I Paid by Bank Transfer
          </button>
        </div>
      `;
    } else {
      manualInfo.style.display = "none";
      manualInfo.innerHTML = "";
    }
  });

  // Form submission
  form.onsubmit = function(e) {
    e.preventDefault();
    const email = form.email.value;
    const plan = planSelect.value;
    const duration = document.getElementById("durationSelect").value;
    const payment_method = paymentMethodField.value;

    let amount = coursePrice;
    if (plan === "premium") amount *= 2;

    const reference = 'SUB_' + Math.floor(Math.random() * 1000000000 + 1);

    fetch("php/subscribe.php", {
      method: "POST",
      headers: {"Content-Type": "application/x-www-form-urlencoded"},
      body: new URLSearchParams({
        email,
        course_id,
        duration,
        plan,
        amount,
        reference,
        payment_method
      })
    })
    .then(res => res.json())
    .then(data => {

      if (payment_method === "paystack") {
        if (typeof PaystackPop === "undefined") {
          alert("Paystack script not loaded!");
          return;
        }
        const handler = PaystackPop.setup({
          key: 'pk_test_263fe98c1ab94e9f489c7d4c6dec6595f36d1472',
          email: email,
          amount: amount * 100,
          currency: "NGN",
          ref: reference,
          onClose: function() { alert("Payment window closed."); },
          callback: function(response) {
            fetch("php/verify_payment.php", {
              method: "POST",
              body: new URLSearchParams({
                reference: response.reference,
                subscription_id: data.subscription_id
              })
            })
            .then(res => res.json())
            .then(result => {
              if(result.status === "success") alert(result.message);

              // ✅ GO TO LIVE CLASSES
            window.location.href = " live_classes.php";
            });
          }
        });
        handler.openIframe();

      } else {
        // Update manualInfo with real reference
        manualInfo.style.display = "block";
        manualInfo.innerHTML = `
          <div style="padding:10px; background:#f9f9f9; border:1px solid #ddd;">
            <strong>Bank Account Details:</strong><br>
            Bank: GTBank<br>
            Account Name: Your School Name<br>
            Account Number: 0123456789<br><br>
            <div style="background:#e6ffe6; padding:10px; border-left:4px solid green;">
              Manual payment selected. Use the reference below when paying.
            </div>
            <div style="color:green; font-size:18px; font-weight:bold; margin-top:10px;">
              Payment Reference: ${reference}
            </div>
            <button type="button" id="verifyManualBtn" 
                style="margin-top:15px; padding:10px; background:#006600; color:white; border:none;"
                data-subscription-id="${data.subscription_id}">
                I Paid by Bank Transfer
            </button>
          </div>
        `;

        const manualBtn = document.getElementById("verifyManualBtn");
        manualBtn.onclick = () => {
          const subscription_id = manualBtn.dataset.subscriptionId;
          fetch('php/verify_manual_payment.php', {
            method: 'POST',
            headers: {"Content-Type": "application/x-www-form-urlencoded"},
            body: new URLSearchParams({ subscription_id })
          })
          .then(res => res.json())
          .then(result => {
            if(result.status === "success") {
              alert("Payment verified! Subscription is now active.");
            } else {
              alert(result.message || "Payment not verified yet.");
            }
          });
        };
      }
    })
    .catch(err => console.log(err));
  };
}

const video = document.getElementById("mainVideo");

video.addEventListener("ended", () => {
    fetch("php/mark_video_watched.php", {
        method: "POST",
        headers: {"Content-Type": "application/x-www-form-urlencoded"},
        body: new URLSearchParams({
            course_id: document.getElementById("courseId").value,
            video_id: document.getElementById("courseId").value
        })
    });
});



