// =======================
// GLOBAL STATE
// =======================
let selectedCategoryId = null;
let currentPage = 1;
const COURSES_PER_PAGE = 4;

let modulesList = [];
let currentModuleIndex = 0;
let completedModules = {}; // { courseId: [moduleIds...] }
// =======================
// Load Categories
// =======================
fetch("php/fetch_categories.php")
.then(res => res.json())
.then(categories => {
    const wrapper = document.getElementById("categories");
    categories.forEach(cat => {
        const div = document.createElement("div");
        div.classList.add("category-item");
        div.textContent = cat.name;
        div.dataset.id = cat.id;

        div.onclick = () => {
            document.querySelectorAll(".category-item").forEach(el => el.classList.remove("selected"));
            div.classList.add("selected");
            selectedCategoryId = cat.id;
            fetchCourses(cat.id);
        };

        wrapper.appendChild(div);
    });
});

// =======================
// Fetch Courses
// =======================
function fetchCourses(category_id, page=1) {
    currentPage = page;
    fetch("php/fetch_courses.php", {
        method:"POST",
        headers: {"Content-Type":"application/x-www-form-urlencoded"},
        body: `category_id=${category_id}&page=${page}&limit=${COURSES_PER_PAGE}`
    })
    .then(res => res.json())
    .then(data => {
        const wrapper = document.getElementById("courses");
        wrapper.innerHTML = "";

        data.courses.forEach(course => {
            const div = document.createElement("div");
            div.classList.add("course-item");

            div.innerHTML = `
                <strong>${course.name}</strong> <br>
                Level: ${course.level} | Price: ₦${course.price} <br>
                <button onclick="loadModules(${course.id})">View Modules</button>
                <div id="modulesBox_${course.id}"></div>
            `;
            wrapper.appendChild(div);
        });

        renderPagination(data.total_pages);
    });
}

// =======================
// Load Modules
// =======================
// function loadModules(courseId) {
//     const box = document.getElementById(`modulesBox_${courseId}`);
//     if(!box) return;
//     box.innerHTML = "Loading modules...";

//     fetch("php/fetch_modules.php", {
//         method:"POST",
//         headers: {"Content-Type":"application/x-www-form-urlencoded"},
//         // body: `course_id=${courseId}`
//         body: "course_id="+courseId
//     })
//     .then(res => res.json())
//     .then(data => {
//         modulesList = data.sort((a,b) => a.module_order - b.module_order);
//         currentModuleIndex = 0;

//         box.innerHTML = "";
//         modulesList.forEach((m, index) => {
//             let status = m.is_free == 1 ? "Free" : "Locked";
//             box.innerHTML += `
//                 <div class="module-item" id="module_${m.id}">
//                     ${m.title} - ${status} 
//                     <button onclick="playModuleByIndex(${index})">Play</button>
//                 </div>
//             `;
//         });
//     });
// }

function loadModules(courseId) {

    // THIS ALERT MUST SHOW THE ACTUAL NUMBER
    alert("Course ID sent: " + courseId);

    const box = document.getElementById("modulesBox_" + courseId);

    if (!box) {
        alert("modulesBox not found for course " + courseId);
        return;
    }

    box.innerHTML = "Loading modules...";

    fetch("php/fetch_modules.php", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: "course_id=" + courseId
    })
    .then(res => res.json())
    .then(modules => {
        box.innerHTML = "";

        if (modules.length === 0) {
            box.innerHTML = "No modules found for this course.";
            return;
        }

 // SET GLOBAL MODULE LIST
    modulesList = modules.sort((a,b) => a.module_order - b.module_order);
    currentModuleIndex = 0;


        modules.forEach((m, i) => {
            let lock = m.is_free == 1 ? "🆓 Free" : "🔒 Locked";

            box.innerHTML += `
                <div class="module-item" id="module_${m.id}">
                    ${i+1}. ${m.title} - ${lock}
                    <button onclick="playModule(${m.id},${m.is_free},${m.course_id})">Play</button>
                </div>
            `;
        });
    })
    .catch(err => {
        console.log(err);
        box.innerHTML = "Error loading modules";
    });
}



// playModule

function playModule(id, is_free, course_id){
    if(is_free == 1){
        const module = modulesList.find(m => m.id == id);
        if(!module) return;

        currentModuleIndex = modulesList.indexOf(module);
        const video = document.getElementById("mainVideo");
        video.src = `courses/${module.video_file}`;
        video.play();
        highlightCurrentModule();

        video.onended = () => {
          markModuleCompleted(module.course_id, module.id);
            const nextModule = modulesList[currentModuleIndex + 1];
            if(nextModule){
                if(nextModule.is_free){
                    currentModuleIndex++;
                    playModuleByIndex(currentModuleIndex);
                } else {
                    showSubscribePrompt(nextModule.course_id);
                }
            }
        };
    } else {
        showSubscribePrompt(course_id);
    }
}

//mark play module as completed

function markModuleCompleted(courseId, moduleId) {
    if (!completedModules[courseId]) completedModules[courseId] = [];
    if (!completedModules[courseId].includes(moduleId)) {
        completedModules[courseId].push(moduleId);
    }

    // check if all modules are completed
    const allModuleIds = modulesList.map(m => m.id);
    if (allModuleIds.every(id => completedModules[courseId].includes(id))) {
        showCertificateButton(courseId);
    }
}


// Show "Generate Certificate" Button
function showCertificateButton(courseId) {
    const wrapper = document.getElementById(`modulesBox_${courseId}`);
    if (!wrapper) return;

    // Add Generate Certificate button
    if (!document.getElementById(`certificateBtn_${courseId}`)) {
        const btn = document.createElement("button");
        btn.id = `certificateBtn_${courseId}`;
        btn.textContent = "Generate Certificate 🎓";
        btn.onclick = () => generateCertificate(courseId);
        wrapper.appendChild(btn);
    }
}

// Generate Certificate
function generateCertificate(courseId) {
    window.open(`php/generate_certificate.php?course_id=${courseId}`, "_blank");
}



// =======================
// Play module by index
// =======================
function playModuleByIndex(index) {
    const module = modulesList[index];
    if(!module) return;

    if(module.is_free == 1) {
        currentModuleIndex = index;
        const video = document.getElementById("mainVideo");
        video.src = `courses/${module.video_file}`;
        video.play();
        highlightCurrentModule();

        video.onended = () => {
            const nextModule = modulesList[currentModuleIndex + 1];
            if(nextModule){
                if(nextModule.is_free){
                    currentModuleIndex++;
                    playModuleByIndex(currentModuleIndex);
                } else {
                    showSubscribePrompt(nextModule.course_id);
                }
            }
        };
    } else {
        showSubscribePrompt(module.course_id);
    }
}

// =======================
// Highlight current module
// =======================
function highlightCurrentModule() {
    modulesList.forEach(m => document.getElementById(`module_${m.id}`).style.background = '');
    if(modulesList[currentModuleIndex]){
        const el = document.getElementById(`module_${modulesList[currentModuleIndex].id}`);
        el.style.background = '#0d6efd';
        el.style.color = '#fff';
    }
}

// =======================
// Pagination
// =======================
function renderPagination(totalPages) {
    const container = document.getElementById("pagination");
    container.innerHTML = "";

    for(let i=1;i<=totalPages;i++){
        container.innerHTML += `<button onclick="fetchCourses(${selectedCategoryId}, ${i})">${i}</button> `;
    }
}

// =======================
// Subscription Modal
// =======================
// function showSubscribePrompt(courseId){
//     const box = document.getElementById("subscriptionForm");
//     box.style.display = "flex";
//     box.innerHTML = `
//         <div style="background:#fff; padding:20px; border-radius:10px; max-width:400px; text-align:center;">
//             <h3>Subscribe to unlock this course</h3>
//             <label>Select Plan:</label><br>
//             <select id="subscriptionPlan">
//                 <option value="daily">Daily</option>
//                 <option value="weekly">Weekly</option>
//                 <option value="monthly">Monthly</option>
//                 <option value="yearly">Yearly</option>
//             </select>
//             <br><br>
//             <input type="number" id="subscriptionNumber" placeholder="Number of days/weeks/months/years" min="1">
//             <br><br>
//             <button onclick="subscribeCourse(${courseId})">Subscribe</button>
//             <button onclick="box.style.display='none'">Close</button>
//         </div>
//     `;
// }

// function subscribeCourse(courseId) {
//     const plan = document.getElementById("subscriptionPlan").value;
//     const number = parseInt(document.getElementById("subscriptionNumber").value);

//     if(!number || number < 1) return alert("Enter a valid number");

//     fetch("php/subscribe_course.php", {
//         method: "POST",
//         headers: { "Content-Type": "application/x-www-form-urlencoded" },
//         body: `course_id=${courseId}&plan=${plan}&number=${number}`
//     })
//     .then(res => res.json())
//     .then(data => {
//         if(data.success){
//             alert("Subscription successful! You can now access the course.");
//             document.getElementById("subscriptionForm").style.display = "none";
//             // Optionally refresh modules
//             loadModules(courseId);
//         } else {
//             alert(data.message);
//         }
//     });
// }

// =======================
// Subscription Modal
// =======================
function showSubscribePrompt(courseId) {
    const box = document.getElementById("subscriptionForm");
    box.style.display = "flex";

    // Fetch course info from backend
    fetch("php/get_course.php", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: `course_id=${courseId}`
    })
    .then(res => res.json())
    .then(course => {
        if (!course || !course.price || !course.name) {
            alert("Unable to load course info.");
            return;
        }

        box.innerHTML = `
            <div style="
                background:#fff; 
                padding:20px; 
                border-radius:10px; 
                max-width:450px; 
                margin:auto;
                text-align:left;
            ">
                <h3 style="text-align:center;">Subscribe to Course</h3>
                <h5 style="font-weight:600; margin:10px 0;">
                    📘 ${course.name}
                </h5>

                <form id="subForm">
                    <input type="hidden" name="course_id" value="${courseId}">
                    <input type="hidden" name="amount" id="planAmount">
                    <input type="hidden" name="payment_method" id="paymentMethod" value="paystack">

                    <label>Email:</label>
                    <input type="email" name="email" required style="width:100%; padding:5px; margin-bottom:10px;">

                    <label>Subscription Plan:</label>
                    <select id="planSelect" required style="width:100%; padding:5px; margin-bottom:10px;">
                        <option value="regular">Regular (Basic Access)</option>
                        <option value="premium">Premium (Full Access)</option>
                        <option value="daily">Daily</option>
                        <option value="weekly">Weekly</option>
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                    </select>

                    <div id="planNumberDiv" style="display:none; margin-bottom:10px;">
                        <label>Number of units:</label>
                        <input type="number" id="planNumber" min="1" value="1" style="width:100%; padding:5px;">
                        <small>Enter number of days/weeks/months/years</small>
                    </div>

                    <p id="priceDisplay" style="margin-top:10px; font-weight:bold;"></p>

                    <label>Payment Method:</label>
                    <select id="paymentMethodSelect" style="width:100%; padding:5px; margin-bottom:10px;">
                        <option value="paystack">Pay Online (Paystack)</option>
                        <option value="manual">Manual Bank Transfer</option>
                    </select>

                    <div id="manualInfo" style="display:none; margin-bottom:10px;"></div>

                    <div style="text-align:center; margin-top:15px;">
                        <button type="submit" style="
                            padding:10px 15px; 
                            background:#007bff; color:white; 
                            border:none; border-radius:5px; margin-right:10px;
                        ">Subscribe Now</button>

                        <button type="button" id="closeForm" style="
                            padding:10px 15px; 
                            background:#ccc; color:black; 
                            border:none; border-radius:5px;
                        ">Close</button>
                    </div>
                </form>
            </div>
        `;

        const planSelect = document.getElementById("planSelect");
        const planNumberDiv = document.getElementById("planNumberDiv");
        const planNumber = document.getElementById("planNumber");
        const amountField = document.getElementById("planAmount");
        const priceDisplay = document.getElementById("priceDisplay");
        const form = document.getElementById("subForm");
        const paymentMethodSelect = document.getElementById("paymentMethodSelect");
        const paymentMethodField = document.getElementById("paymentMethod");
        const manualInfo = document.getElementById("manualInfo");
        const closeFormBtn = document.getElementById("closeForm");

        // Close modal
        closeFormBtn.onclick = () => box.innerHTML = "";

        // Update price display
        function updatePrice() {
            let amount = parseFloat(course.price);

            // Premium doubles price
            if(planSelect.value === "premium") amount *= 2;

            // For daily/weekly/monthly/yearly, multiply by number
            if(["daily","weekly","monthly","yearly"].includes(planSelect.value)){
                planNumberDiv.style.display = "block";
                let num = parseInt(planNumber.value) || 1;
                amount = amount * num;
            } else {
                planNumberDiv.style.display = "none";
            }

            amountField.value = amount.toFixed(2);
            priceDisplay.textContent = "Price: ₦" + amount.toLocaleString();
        }

        updatePrice();
        planSelect.addEventListener("change", updatePrice);
        planNumber.addEventListener("input", updatePrice);

        // Toggle manual info
        paymentMethodSelect.addEventListener("change", () => {
            const method = paymentMethodSelect.value;
            paymentMethodField.value = method;

            if (method === "manual") {
                manualInfo.style.display = "block";
                const tempReference = 'TEMP_' + Math.floor(Math.random() * 1000000 + 1);
                manualInfo.innerHTML = `
                    <div style="padding:10px; background:#f9f9f9; border:1px solid #ddd;">
                        <strong>Bank Account Details:</strong><br>
                        Bank: GTBank<br>
                        Account Name: Your School Name<br>
                        Account Number: 0123456789<br><br>
                        <div style="background:#e6ffe6; padding:10px; border-left:4px solid green;">
                            Manual payment selected. Reference will appear after submitting.
                        </div>
                        <div style="color:green; font-size:16px; font-weight:bold; margin-top:10px;">
                            Temporary Reference: ${tempReference}
                        </div>
                        <button type="button" id="verifyManualBtn" style="display:none; margin-top:10px;">
                            I Paid by Bank Transfer
                        </button>
                    </div>
                `;
            } else {
                manualInfo.style.display = "none";
                manualInfo.innerHTML = "";
            }
        });

        // Form submission
        form.onsubmit = function(e) {
            e.preventDefault();
            const email = form.email.value;
            const plan = planSelect.value;
            const numberVal = parseInt(planNumber.value) || 1;
            const payment_method = paymentMethodField.value;
            const amount = parseFloat(amountField.value);
            const reference = 'SUB_' + Math.floor(Math.random() * 1000000000 + 1);

            // Send subscription request
            fetch("php/subscribe.php", {
                method: "POST",
                headers: {"Content-Type": "application/x-www-form-urlencoded"},
                body: new URLSearchParams({
                    email,
                    course_id: courseId,
                    plan,
                    number: numberVal,
                    amount,
                    reference,
                    payment_method
                })
            })
            .then(res => res.json())
            .then(data => {

                if(payment_method === "paystack") {
                    if(typeof PaystackPop === "undefined"){
                        alert("Paystack script not loaded!");
                        return;
                    }

                    const handler = PaystackPop.setup({
                        key: 'pk_test_263fe98c1ab94e9f489c7d4c6dec6595f36d1472',
                        email: email,
                        amount: amount * 100,
                        currency: "NGN",
                        ref: reference,
                        onClose: function() { alert("Payment window closed."); },
                        callback: function(response) {
                            fetch("php/verify_payment.php", {
                                method: "POST",
                                body: new URLSearchParams({
                                    reference: response.reference,
                                    subscription_id: data.subscription_id
                                })
                            })
                            .then(res => res.json())
                            .then(result => {
                                if(result.status === "success") alert(result.message);
                                // redirect to course modules or live classes
                                window.location.href = "live_classes.php";
                            });
                        }
                    });
                    handler.openIframe();
                } else {
                    // Show real manual reference
                    manualInfo.style.display = "block";
                    manualInfo.innerHTML = `
                        <div style="padding:10px; background:#f9f9f9; border:1px solid #ddd;">
                            <strong>Bank Account Details:</strong><br>
                            Bank: GTBank<br>
                            Account Name: Your School Name<br>
                            Account Number: 0123456789<br><br>
                            <div style="background:#e6ffe6; padding:10px; border-left:4px solid green;">
                                Manual payment selected. Use the reference below when paying.
                            </div>
                            <div style="color:green; font-size:18px; font-weight:bold; margin-top:10px;">
                                Payment Reference: ${reference}
                            </div>
                            <button type="button" id="verifyManualBtn" 
                                style="margin-top:15px; padding:10px; background:#006600; color:white; border:none; border-radius:5px;"
                                data-subscription-id="${data.subscription_id}">
                                I Paid by Bank Transfer
                            </button>
                        </div>
                    `;

                    const manualBtn = document.getElementById("verifyManualBtn");
                    manualBtn.onclick = () => {
                        const subscription_id = manualBtn.dataset.subscriptionId;
                        fetch('php/verify_manual_payment.php', {
                            method: 'POST',
                            headers: {"Content-Type": "application/x-www-form-urlencoded"},
                            body: new URLSearchParams({ subscription_id })
                        })
                        .then(res => res.json())
                        .then(result => {
                            if(result.status === "success") {
                                alert("Payment verified! Subscription is now active.");
                                box.innerHTML = "";
                                loadModules(courseId); // unlock course modules
                            } else {
                                alert(result.message || "Payment not verified yet.");
                            }
                        });
                    };
                }

            })
            .catch(err => console.error(err));
        };
    })
    .catch(err => console.error("Course fetch error:", err));
}

