<?php
// require_once __DIR__ . '/includes/header.php';
?>

<!DOCTYPE html>
<html>
<head>
    <title>Course Platform</title>
    <!-- <link rel="stylesheet" href="style.css"> -->
    <style>
/* ===========================
   GLOBAL
=========================== */
body {
    font-family: Arial, sans-serif;
    background: #f2f4f7;
    margin: 0;
    padding: 0;
}

.container {
    max-width: 1000px;
    margin: 50px auto;
    background: #fff;
    padding: 25px;
    border-radius: 8px;
    box-shadow: 0 5px 15px rgba(0,0,0,.1);
}

h2 {
    text-align: center;
    margin-bottom: 25px;
    color: #fff;
    background: #0d6efd;
    padding: 12px;
    border-radius: 8px;
}

/* ===========================
   CATEGORY & COURSE LIST
=========================== */
#categories, #courses, #subscriptionForm {
    margin-bottom: 30px;
}

.category-item,
.course-item,
.module-item {
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 6px;
    margin-bottom: 10px;
    cursor: pointer;
    transition: background 0.3s, transform 0.2s;
}

.category-item:hover,
.course-item:hover,
.module-item:hover {
    background: #f1f2f3ff;
    color: #000000ff !important;
    transform: translateY(-2px);
}

.category-item:hover *,
.course-item:hover *,
.module-item:hover * {
    color: #000000ff !important;
}


.selected {
    background: #198754 !important;
    color: #fff;
}

#courses .course-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

/* ===========================
   BUTTONS
=========================== */
button,
.subscribe-btn {
    padding: 6px 12px;
    background: #0d6efd;
    color: #fff;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    transition: background 0.3s;
}

button:hover,
.subscribe-btn:hover {
    background: #084298;
}

/* ===========================
   FORMS
=========================== */
form {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

form input,
form select,
form button {
    padding: 10px;
    border-radius: 4px;
    border: 1px solid #ddd;
}

form button {
    background: #198754;
    font-size: 16px;
}

form button:hover {
    background: #146c43;
}

/* ===========================
   ALERTS
=========================== */
.error {
    background: #ffdddd;
    color: #b10000;
    padding: 10px;
    border-left: 4px solid red;
    margin-bottom: 15px;
}

.success {
    background: #ddffdd;
    color: #006400;
    padding: 10px;
    border-left: 4px solid green;
    margin-bottom: 15px;
}

/* ===========================
   VIDEO DISPLAY
=========================== */
#courses video,
#mainVideo {
    width: 100%;
    max-width: 600px;
    height: auto;
    aspect-ratio: 16 / 9;
    border-radius: 8px;
    margin-top: 15px;
    object-fit: cover;
    box-shadow: 0 3px 10px rgba(0,0,0,0.15);
    transition: transform 0.2s;
}

#courses video:hover,
#mainVideo:hover {
    transform: scale(1.03);
}

/* ===========================
   SUBSCRIPTION MODAL
=========================== */
#subscriptionForm {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.6);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 9999;
}

/* ===========================
   PAGINATION
=========================== */
#pagination {
    margin-top: 20px;
    text-align: center;
}

/* ===========================
   MODULE UI (UDEMY STYLE)
=========================== */
.module-item {
    background: #f9f9f9;
    padding: 8px 10px;
    border-radius: 5px;
    margin-bottom: 4px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    font-size: 14px;
}

.module-item:hover {
    background: #e6f0ff;
}

.toggle-btn {
    width: 22px;
    height: 22px;
    border: none;
    background: #0d6efd;
    color: white;
    font-weight: bold;
    border-radius: 50%;
    cursor: pointer;
    margin-right: 8px;
}

.submodules {
    margin-left: 20px;
    padding-left: 10px;
}

.arrow {
    display:inline-block;
    margin-right:8px;
    cursor:pointer;
    transition: transform 0.3s ease;
    font-size:14px;
    color:#0d6efd;
}

.arrow.rotate {
    transform: rotate(90deg);
}

</style>

</head>
<body>
    <div class="container">
        <h2 style="color: white; height: 28px; background: blue; border-radius: 10px; text-transform: uppercase;">Browse Courses by Category</h2>

        <div id="categories">
            <!-- Categories will load here -->
        </div>
        <br><br>

        <div id="courses">
            <!-- Courses will load here -->
        </div>

        <br><br>
        <h3>Course Modules</h3>
        <div id="modulesBox_1"></div>
        <div class="module-item" id="module_${m.id}">

        </div>

<video id="mainVideo" controls width="500">
    <div style="margin-top:10px; text-align:center;">
    <button id="nextModuleBtn" style="
        padding:10px 15px; background:#0d6efd; color:white; border:none; border-radius:5px;">
        ▶ Next Module
    </button>
</div>
</video>
<!-- <video id="mainVideo" controls width="500"></video> -->



<!-- 
<button onclick="loadModules(${course.id})">View Modules</button>
<button onclick="playModule(module.id, module.is_free, module.course_id)">Play</button> -->

<br><br>

<div id="courses"></div>

<div id="pagination" style="margin-top:20px; text-align:center;"></div>


<br><br>
        <!-- <div id="subscriptionForm"> -->
        <!-- <div id="subscriptionForm" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); justify-content:center; align-items:center; z-index:9999;"></div>

            <- Subscription form will load here -->
        <!-- </div> -->
    </div>

<div id="subscriptionForm" style="
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0,0,0,0.6);
  display: none;
  justify-content: center;
  align-items: center;
  z-index: 9999;
"></div>



<!-- Load Paystack library -->
<script src="https://js.paystack.co/v1/inline.js"></script>

<!-- Load your script -->

    <script src="js/script.js"></script>
</body>
</html>
