<?php
require_once __DIR__ . '/includes/header.php';
?>

<style>

/* ===========================
   GLOBAL STYLING
=========================== */
body {
  font-family: "Poppins", sans-serif;
}

/* ===========================
   HERO SECTION
=========================== */
.hero {
  position: relative;
  padding: 80px 0;
  background: #f8f9fa;
  overflow: hidden;
}

/* Floating background shapes */
.hero::before,
.hero::after {
  content: "";
  position: absolute;
  width: 180px;
  height: 180px;
  background: rgba(13, 110, 253, 0.15);
  border-radius: 50%;
  animation: floatAnim 8s ease-in-out infinite;
}

.hero::before {
  top: -40px;
  right: -40px;
}

.hero::after {
  bottom: -50px;
  left: -50px;
  width: 220px;
  height: 220px;
  background: rgba(255, 193, 7, 0.18);
  animation-delay: 3s;
}

@keyframes floatAnim {
  0% { transform: translateY(0); }
  50% { transform: translateY(-25px); }
  100% { transform: translateY(0); }
}

/* ===========================
   TEXT ANIMATION
=========================== */
.fade-in {
  opacity: 0;
  transform: translateY(20px);
  animation: fadeInUp 1s ease-out forwards;
}

.fade-delay-1 { animation-delay: .3s; }
.fade-delay-2 { animation-delay: .6s; }
.fade-delay-3 { animation-delay: .9s; }

@keyframes fadeInUp {
  to { opacity: 1; transform: translateY(0); }
}

/* Animated gradient title */
.gradient-title {
  background: linear-gradient(90deg, #0d6efd, #20c997, #ffbb00, #6610f2);
  background-size: 300%;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  animation: gradientMove 6s ease infinite;
}

@keyframes gradientMove {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

/* ===========================
   BUTTON ANIMATIONS
=========================== */
.glow-btn {
  transition: .3s;
}

.glow-btn:hover {
  transform: translateY(-3px);
  box-shadow: 0 0 15px rgba(13,110,253,.4);
}

/* ===========================
   HOW-IT-WORKS CARDS
=========================== */
.card-animated {
  transition: .4s ease;
  border-radius: 18px;
}

.card-animated:hover {
  transform: translateY(-6px);
  box-shadow: 0 10px 25px rgba(0,0,0,0.12);
}

/* List animation */
.hiw-list li {
  opacity: 0;
  transform: translateX(-15px);
  animation: listSlide .7s ease forwards;
}

.hiw-list li:nth-child(1) { animation-delay: .2s; }
.hiw-list li:nth-child(2) { animation-delay: .4s; }
.hiw-list li:nth-child(3) { animation-delay: .6s; }
.hiw-list li:nth-child(4) { animation-delay: .8s; }
.hiw-list li:nth-child(5) { animation-delay: 1s; }
.hiw-list li:nth-child(6) { animation-delay: 1.2s; }
.hiw-list li:nth-child(7) { animation-delay: 1.4s; }
.hiw-list li:nth-child(8) { animation-delay: 1.6s; }

@keyframes listSlide {
  to { opacity: 1; transform: translateX(0); }
}

/* Responsive Image */
.hero img {
  max-height: 350px;
}

/* Mobile adjustments */
@media(max-width: 768px){
  .hero {
    padding: 50px 0;
    text-align: center;
  }
  .hero img {
    margin-top: 20px;
    max-height: 260px;
  }
}

</style>


<!-- ===========================
     HERO SECTION
=========================== -->
<div class="hero mb-5">
  <div class="container">
    <div class="row align-items-center">

      <!-- <div class="col-md-7 fade-in"> -->
        <h1 class="display-4 fw-bold gradient-title">EXCELLENTHUB ONLINE CLASSES</h1>
        <h3 class="mb-3 fade-delay-1">Learn Anytime, Anywhere</h3>

        <h5 class="mb-4 fade-delay-2">
          <button class="btn btn-outline-success btn-lg me-2 glow-btn">DIGITAL SKILL</button>
        </h5>

        <p class="lead fade-delay-3">
          Access lesson notes, video lessons, live classes, assessments and downloadable curricula —  
          all focused on DIGITAL LEARNING.
        </p>

        <div class="mt-4 fade-delay-3">
          <!-- <a href="register.php?redirect=live_classes.php" class="btn btn-primary btn-lg me-2 glow-btn">Get Started</a>👩‍🏫  -->
          <a href="register.php?redirect=live_classes.php" 
          class="btn btn-outline-primary btn-lg me-2 glow-btn">
            Get Started
          </a>

            <a href="login.php?redirect=live_classes.php" 
              class="btn btn-outline-primary btn-lg me-2 glow-btn">
            👩‍🏫 Live Class
            </a>


          <a class="btn btn-outline-success btn-lg glow-btn" href="https://wa.me/2348067207668">WhatsApp</a>
        </div>
      </div>

      <div class="col-md-5 text-center fade-in fade-delay-2">
        <img src="assets/hero-video-placeholder.png" alt="Video Guide" class="img-fluid">
      </div>

    </div>
  </div>
</div>


<!-- ===========================
     HOW IT WORKS
=========================== -->
<div class="container">
  <div class="row">

    <div class="col-md-8">
      <div class="card card-animated mb-4">
        <div class="card-body">
          <h4 class="fw-bold mb-3">📘 How It Works</h4>

          <ol class="hiw-list">
            <li><strong>Register an Account:</strong> Click <em>Get Started</em> to create your free student profile.</li>
            <li><strong>Access Tutorials:</strong> Browse videos & live classes.</li>
            <!-- <li><strong>Download Notes:</strong> Save high-quality notes for revision.</li> -->
            <li><strong>Watch Video Lessons:</strong> Stream tutor-guided videos.</li>
            <li><strong>Join Live Classes:</strong> Interact with expert tutors in real time.</li>
            <li><strong>Take Assessments:</strong> Submit assignments & receive corrections.</li>
            <li><strong>Track Progress:</strong> View your scores instantly.</li>
            <li><strong>Get Support:</strong> Our team is always available.</li>
          </ol>

        </div>
      </div>
    </div>

    <div class="col-md-4">

      <div class="card card-animated mb-4">
        <div class="card-body">
          <h5 class="fw-bold">Quick Links</h5>
          <ul class="list-unstyled mt-2">
            <li>🎥 Video Guide</li>
            <li><a href="view_tutorials.php">📚 Tutorials</a></li>
            <li><a href="contact.php">📞 Contact Us</a></li>
          </ul>
        </div>
      </div>

      <div class="card card-animated">
        <div class="card-body">
         <h5 class="fw-bold">Support</h5>
<p>
  Need help? WhatsApp 
  <a href="https://wa.me/2348134843148?text=Hello%20I%20need%20help%20with%20your%20platform" target="_blank">
  0813 484 3148
</a>

  <br>
  or email 
  <a href="mailto:exgis2020@gmail.com">
    exgis2020@gmail.com
  </a>
</p>

        </div>
      </div>

    </div>

  </div>
</div>

<?php
require_once __DIR__ . '/includes/footer.php';
?>
