<?php
// require_once '..php/config.php'; // Config.php should already start the session and define is_logged_in() & current_user()
require_once __DIR__ . '/../php/config.php';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>EXCELLENT GRADE — Online Classes</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    .sticky-navbar {
      position: sticky;
      top: 0;
      z-index: 1030;
    }

    .hero {
      background: linear-gradient(135deg,#0d6efd22,#6c757d11);
      padding: 60px 0;
    }
    .card-fixed {
      min-height: 20px;
    }
  </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-navbar">
  <div class="container">
    <a class="navbar-brand" href="index.php">
      <img src="/assets/logo.png" alt="Logo" height="34" onerror="this.style.display='none'"> EXCELLENT GRADE HUB
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navMain">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="index.php">🏠 Home</a></li>
        <li class="nav-item"><a class="nav-link" href="index1.php">📚 Tutorials</a></li>
        <li class="nav-item"><a class="nav-link" href="contact.php">📞 Contact Us</a></li>
      </ul>

      <div class="d-flex align-items-center">
        <?php if (is_logged_in()): 
            $u = current_user(); 
        ?>
          <span class="me-3">Welcome, <?= htmlspecialchars($u['fullname'] ?? 'User') ?></span>
          <a class="btn btn-outline-secondary btn-sm me-2" href="dashboard.php">Dashboard</a>
          <a class="btn btn-outline-danger btn-sm" href="logout.php">Logout</a>
        <?php else: ?>
          <a class="btn btn-outline-primary btn-sm me-2" href="login.php">🔐 Login</a>
          <a class="btn btn-primary btn-sm" href="register.php">Get Started</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</nav>

<div class="container mt-4">
