<?php
require_once 'php/config.php'; // DB connection
require('fpdf/fpdf.php');

session_start();
$user_id = $_SESSION['user_id']; // logged in user

$course_id = $_GET['course_id'];

// Fetch user and course info
$stmt = $pdo->prepare("SELECT u.name as user_name, c.name as course_name FROM users u JOIN courses c ON c.id=? WHERE u.id=?");
$stmt->execute([$course_id, $user_id]);
$data = $stmt->fetch();

if(!$data) die("Invalid data");

$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,'Certificate of Completion',0,1,'C');
$pdf->Ln(10);
$pdf->SetFont('Arial','',14);
$pdf->MultiCell(0,10,"This is to certify that {$data['user_name']} has successfully completed the course: {$data['course_name']}.");
$pdf->Ln(20);
$pdf->Cell(0,10,"Date: ".date("d-M-Y"),0,1,'C');

$pdf->Output();
?>
