<?php
session_start();
require_once "php/config.php";

// PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require "vendor/autoload.php";

$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $email = trim($_POST["email"]);

    if (empty($email)) {
        $message = "<div class='alert alert-danger'>Email is required</div>";
    } else {
        // Check if user exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);

        if ($stmt->rowCount() === 1) {
            $token  = bin2hex(random_bytes(32));
            $expiry = date("Y-m-d H:i:s", strtotime("+1 hour"));

            // Save token
            $update = $pdo->prepare("UPDATE users SET reset_token = ?, token_expiry = ? WHERE email = ?");
            $update->execute([$token, $expiry, $email]);
// $reset_link = "http://localhost/excellenthub/reset_password.php?token=$token";
            // 🔹 Dynamic reset link for localhost & live server
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
            $domain   = $_SERVER['HTTP_HOST'];
            $reset_link = $protocol . "://" . $domain . "/EXCELLENTHUB/reset_password.php?token=" . $token;

            // Send Email
            $mail = new PHPMailer(true);
            try {
                $mail->isSMTP();
                $mail->Host       = 'smtp.gmail.com';
                $mail->SMTPAuth   = true;
                $mail->Username   = 'umohek@gmail.com';     // 🔴 CHANGE
                $mail->Password   = 'ygjilbyvozfduaip';       // 🔴 CHANGE
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                $mail->Port       = 465;
                $mail->CharSet    = 'UTF-8';

                $mail->setFrom('yourgmail@gmail.com', 'ExcellentHub');
                $mail->addAddress($email);

                $mail->isHTML(true);
                $mail->Subject = 'Password Reset Request';
                $mail->Body = "
                    <h3>Password Reset</h3>
                    <p>You requested to reset your password.</p>
                    <p>Click the button below to reset your password:</p>
                    <p>
                        <a href='$reset_link' style='
                            background:#0d6efd;
                            color:#fff;
                            padding:10px 15px;
                            text-decoration:none;
                            border-radius:5px;
                        '>Reset Password</a>
                    </p>
                    <p>This link expires in <b>1 hour</b>.</p>
                    <p>If you did not request this, ignore this email.</p>
                ";

                $mail->send();
                $message = "<div class='alert alert-success'>
                    Password reset link has been sent to your email.
                </div>";

            } catch (Exception $e) {
                $message = "<div class='alert alert-danger'>
                    Mail Error: " . $mail->ErrorInfo . "
                </div>";
            }

        } else {
            $message = "<div class='alert alert-danger'>Email not found</div>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Forgot Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h4 class="text-center mb-3">Forgot Password</h4>
                    <?= $message ?>
                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label">Email Address</label>
                            <input type="email" name="email" class="form-control" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">
                            Send Reset Link
                        </button>
                    </form>
                    <div class="text-center mt-3">
                        <a href="login.php">Back to Login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
