<?php
session_start();
require "php/config.php";

// Ensure user is logged in
if (!isset($_SESSION['user'])) {
    echo json_encode([]);
    exit;
}

$uid = $_SESSION['user']['id'];

$stmt = $pdo->prepare("
    SELECT id, title, message, link, is_read, created_at
    FROM notifications
    WHERE user_id IS NULL OR user_id = ?
    ORDER BY created_at DESC
    LIMIT 20
");

$stmt->execute([$uid]);

echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
