<?php
session_start();
require_once 'php/config.php';

$course_id = $_GET['course_id'] ?? null;
if (!$course_id) {
    echo json_encode([]);
    exit;
}

// Fetch comments for this course
$stmt = $pdo->prepare("
    SELECT vc.*, u.fullname 
    FROM video_comments vc
    INNER JOIN users u ON u.id = vc.user_id
    WHERE vc.course_id = :course_id
    ORDER BY vc.created_at DESC
");
$stmt->execute(['course_id' => $course_id]);
$comments = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch replies for these comments
$comment_ids = array_column($comments, 'id');
$repliesByComment = [];
if ($comment_ids) {
    $in  = str_repeat('?,', count($comment_ids) - 1) . '?';
    $replyStmt = $pdo->prepare("SELECT * FROM comment_replies WHERE comment_id IN ($in) ORDER BY created_at ASC");
    $replyStmt->execute($comment_ids);
    $allReplies = $replyStmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($allReplies as $r) {
        $repliesByComment[$r['comment_id']][] = $r;
    }
}

// Attach replies to comments
foreach ($comments as &$c) {
    $c['replies'] = $repliesByComment[$c['id']] ?? [];
}

echo json_encode($comments);
