<?php
// favorite.php
require_once __DIR__.'/includes/auth.php';
require_once __DIR__.'/includes/config.php';


if(!is_logged_in()){
http_response_code(401);
echo json_encode(['error'=>'login_required']);
exit;
}


$input = json_decode(file_get_contents('php://input'), true);
$course_id = (int)($input['course_id'] ?? 0);
$action = $input['action'] ?? 'toggle';
$user_id = current_user_id();


if(!$course_id){ http_response_code(400); echo json_encode(['error'=>'invalid_course']); exit; }


if($action === 'toggle'){
// check exists
$stmt = $pdo->prepare('SELECT id FROM favorites WHERE user_id=:uid AND course_id=:cid');
$stmt->execute([':uid'=>$user_id, ':cid'=>$course_id]);
$exists = $stmt->fetchColumn();
if($exists){
$pdo->prepare('DELETE FROM favorites WHERE id = :id')->execute([':id'=>$exists]);
echo json_encode(['status'=>'removed']);
} else {
$pdo->prepare('INSERT INTO favorites (user_id, course_id) VALUES (:uid,:cid)')
->execute([':uid'=>$user_id, ':cid'=>$course_id]);
echo json_encode(['status'=>'added']);
}
exit;
}


http_response_code(400);
echo json_encode(['error'=>'unknown_action']);