<?php
// session_start();
require "php/config.php";   // PDO connection

// ===== CHECK LOGIN ===== //
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}

// ===== FETCH USER DETAILS ===== //
$user_id = $_SESSION['user']['id'];

$sql = "SELECT * FROM users WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$user){
    echo "User not found.";
    exit;
}


$fullname = $user['fullname'];
$role     = ucfirst($user['role']);
$photo    = $user['photo'] ?? "assets/hero-video-placeholder.png"; // Optional, if you plan to add profile photos

?>
<!DOCTYPE html>
<html>
<head>
    <title>Student Dashboard</title>

    <!-- Bootstrap 5 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

    <style>
        body{ background:#f8f9fa; }
        .dash-card{
            border-radius:15px;
            transition:0.3s;
            cursor:pointer;
        }
        .dash-card:hover{
            transform:scale(1.03);
            background:#eef3ff;
        }
        .profile-img{
            width:90px;height:90px;border-radius:50%;object-fit:cover;border:3px solid #fff;
        }
    </style>
    <style>
/* Optional hover effect */
.dash-card {
    border-radius: 10px;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.dash-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 0.75rem 1.5rem rgba(0, 0, 0, 0.15);
}

/* Responsive text alignment */
.dash-card h4, .dash-card p {
    margin: 0;
}

/*Notification dropdown*/
.dropdown-menu {
    max-height: 400px;
    overflow-y: auto;
}
.dropdown-item:hover {
    background-color: #f0f0f0;
}

</style>
</head>
<body>

<!-- TOP NAV -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container-fluid">
    <span class="navbar-brand">Student Dashboard</span>

    <!-- <div class="float-end">
      <a href="logout.php" class="btn btn-light btn-sm">Logout</a>
    </div> -->


<?php
// Count unread notifications
$uid = $_SESSION['user']['id'];
$countStmt = $pdo->prepare("SELECT COUNT(*) FROM notifications WHERE is_read=0 AND (user_id IS NULL OR user_id=?)");
$countStmt->execute([$uid]);
$unreadCount = $countStmt->fetchColumn();
?>
<div class="d-flex align-items-center gap-3">
    <div class="dropdown">
    <button class="btn btn-light position-relative dropdown-toggle" type="button" id="notifBell" data-bs-toggle="dropdown" aria-expanded="false">
        🔔
        <span id="notifCount" class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="display:none;">0</span>
    </button>
    <ul class="dropdown-menu dropdown-menu-end" style="width:300px;" id="notifList">
        <li class="text-center p-2">Loading...</li>
    </ul>
</div>

    <a href="logout.php" class="btn btn-light btn-sm">Logout</a>
</div>



  </div>
</nav>

<!-- HEADER -->
<div class="container mt-4 text-center">
    <img src="<?php echo $photo; ?>" class="profile-img mb-2">
    <h2>Welcome, <?php echo $fullname; ?>!</h2>
    <p class="text-muted">Role: <?php echo $role; ?></p>
</div>

<!-- DASHBOARD MENU -->
<div class="container mt-4">
    <div class="row g-3">

        <div class="col-md-4">
            <a href="index1.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📚 Courses</h4>
                    <p>Browse all learning materials</p>
                </div>
            </a>
        </div>

        <!-- <div class="col-md-4">
            <a href="subjects.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📘 Subjects</h4>
                    <p>Select subjects and topics</p>
                </div>
            </a>
        </div> -->

        <div class="col-md-4">
            <a href="login.php?redirect=live_classes.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>🎓 Class Room</h4>
                    <p>Continue your enrolled classes</p>
                </div>
            </a>
        </div>

        <div class="col-md-4">
            <a href="assessments.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📝 Assessments</h4>
                    <p>Take tests </p>
                </div>
            </a>
        </div>

        <div class="col-md-4">
            <a href="student_grades.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>📚 Assignment Score</h4>
                    <p>View Now</p>
                </div>
            </a>
        </div> 

        <div class="col-md-4">
    <a href="assignments.php" class="text-decoration-none">
        <div class="p-4 bg-white shadow dash-card text-center">
            <h4>📂 Assignments</h4>
            <p>View or submit assignments</p>
        </div>
    </a>
</div>
<div class="col-md-4 col-sm-6 mb-3">
    <a href="subscriptions.php" class="text-decoration-none">
        <div class="p-4 bg-white shadow dash-card text-center h-100 hover-shadow">
            <h4>💳 Subscriptions</h4>
            <p>View your subscribed courses</p>
        </div>
    </a>
</div>

        <!-- <div class="col-md-4">
            <a href="profile.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>👤 Account</h4>
                    <p>Manage profile settings</p>
                </div>
            </a>
        </div> -->

        <!-- <div class="col-md-6">
            <a href="view_profile.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>👁 View My Profile</h4>
                    <p>See your public student profile</p>
                </div>
            </a>
        </div> -->

        <!-- <div class="col-md-6">
            <a href="public_profiles.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>👥 Public Profiles</h4>
                    <p>View other students</p>
                </div>
            </a>
        </div> -->

        <div class="col-md-12">
            <a href="index.php" class="text-decoration-none">
                <div class="p-4 bg-white shadow dash-card text-center">
                    <h4>🏠 Home</h4>
                </div>
            </a>
        </div>

    </div>
</div>



<script>
function escapeHtml(text){
    return text ? text.replace(/[&<>"']/g, m => ({
        '&':'&amp;',
        '<':'&lt;',
        '>':'&gt;',
        '"':'&quot;',
        "'":'&#039;'
    }[m])) : '';
}

function fetchNotifications(){
    fetch('fetch_notifications.php')
    .then(res => res.json())
    .then(data => {
        const list = document.getElementById('notifList');
        const count = document.getElementById('notifCount');
        list.innerHTML = '';

        if(data.length === 0){
            list.innerHTML = '<li class="text-center p-2">No notifications</li>';
            count.style.display = 'none';
        } else {
            const unread = data.filter(n => n.is_read == 0).length;
            if(unread > 0){
                count.style.display = 'inline-block';
                count.innerText = unread;
            } else {
                count.style.display = 'none';
            }

            data.forEach(n => {
                const li = document.createElement('li');
                li.className = 'dropdown-item';
                li.innerHTML = `
                    <strong>${escapeHtml(n.title)}</strong><br>
                    ${escapeHtml(n.message)}<br>
                    <small class="text-muted">${new Date(n.created_at).toLocaleString()}</small>
                `;
                li.style.cursor = 'pointer';
                li.onclick = () => {
    // Remove clicked notification from dropdown immediately
    li.remove();

    // Update unread count
    const count = document.getElementById('notifCount');
    let unread = parseInt(count.innerText) || 0;
    unread = Math.max(unread - 1, 0);
    if(unread === 0){
        count.style.display = 'none';
    } else {
        count.innerText = unread;
    }

    // Mark as read in DB
    fetch('mark_notif_read.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'id=' + encodeURIComponent(n.id)
    });

    // Redirect if there is a link
    if(n.link) window.location.href = n.link;
};

                list.appendChild(li);
            });
        }
    })
    .catch(err => {
        console.error("Error fetching notifications:", err);
    });
}

function markAsRead(id){
    fetch('mark_notif_read.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'id=' + encodeURIComponent(id)
    }).then(() => fetchNotifications());
}

// Initial load
fetchNotifications();

// Refresh every 5 seconds
setInterval(fetchNotifications, 5000);
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
