<?php
session_start();
require_once __DIR__ . '/php/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Contact Us | EXCELLENT HUB</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background: #f4f6f9;
            font-family: "Segoe UI", system-ui, sans-serif;
        }

        /* NAVBAR */
        .navbar-brand {
            font-size: 1.4rem;
            letter-spacing: 1px;
        }

        /* HERO */
        .hero {
            background: linear-gradient(135deg, #0d6efd, #084298);
            color: #fff;
            padding: 4rem 1rem;
        }

        .hero h1 {
            font-weight: 700;
        }

        /* CARDS */
        .contact-card {
            border: none;
            border-radius: 16px;
            transition: all 0.3s ease;
        }

        .contact-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
        }

        /* FORM */
        .form-control {
            border-radius: 10px;
            padding: 0.7rem 0.9rem;
        }

        .form-control:focus {
            box-shadow: none;
            border-color: #0d6efd;
        }

        .btn-primary {
            border-radius: 10px;
            padding: 0.7rem 1.8rem;
            font-weight: 600;
        }

        /* CONTACT INFO */
        .info-item {
            display: flex;
            align-items: start;
            gap: 12px;
            margin-bottom: 1.3rem;
        }

        .info-item i {
            font-size: 1.4rem;
            color: #0d6efd;
            margin-top: 4px;
        }

        /* FOOTER */
        footer {
            background: #111;
            color: #aaa;
        }
    </style>
</head>
<body>

<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm">
    <div class="container">
        <a class="navbar-brand fw-bold" href="index.php">EXCELLENTHUB</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMenu">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navMenu">
            <ul class="navbar-nav ms-auto align-items-lg-center">
                <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
                <li class="nav-item"><a class="nav-link" href="index1.php">Courses</a></li>
                <li class="nav-item"><a class="nav-link active fw-semibold" href="contact.php">Contact</a></li>

                <?php if(isset($_SESSION['user'])): ?>
                    <li class="nav-item ms-lg-3">
                        <a class="btn btn-light btn-sm fw-semibold" href="dashboard.php">Dashboard</a>
                    </li>
                <?php else: ?>
                    <li class="nav-item ms-lg-3">
                        <a class="btn btn-outline-light btn-sm fw-semibold" href="login.php">Login</a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>

<button id="darkToggle" class="btn btn-sm btn-outline-light ms-2">
    🌙
</button>


<!-- HERO -->
<section class="hero text-center">
    <div class="container">
        <h1 class="mb-2">Contact Us</h1>
        <p class="lead mb-0">We’re always ready to help you learn better and faster.</p>
    </div>
</section>

<!-- CONTACT SECTION -->
<section class="py-5">
    <div class="container">
        <div class="row g-4 justify-content-center">




            <!-- FORM -->
            <div class="col-lg-7">
                <div class="card contact-card shadow-sm">
                    <div class="card-body p-4 p-md-5">
                        <h4 class="fw-bold mb-4">Send Us a Message</h4>


<?php if(isset($_SESSION['contact_success'])): ?>
<div class="alert alert-success alert-dismissible fade show">
    <?= $_SESSION['contact_success']; unset($_SESSION['contact_success']); ?>
    <button class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if(isset($_SESSION['contact_error'])): ?>
<div class="alert alert-danger alert-dismissible fade show">
    <?= $_SESSION['contact_error']; unset($_SESSION['contact_error']); ?>
    <button class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="mt-4">
<iframe
    src="https://www.google.com/maps?q=Excellent Grade International School Kubwa.  No.1 Reggy Emmanuel Rd., By Mopol Station, Army Scheme Quarters, Kubwa F.C.T Abuja.Nigeria&output=embed"
    width="100%"
    height="220"
    style="border:0;border-radius:12px;"
    loading="lazy">
</iframe>
</div>



                        <form method="post" action="php/send_contact.php">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Full Name</label>
                                    <input type="text" name="name" class="form-control" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email Address</label>
                                    <input type="email" name="email" class="form-control" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Subject</label>
                                    <input type="text" name="subject" class="form-control" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Phone Number</label>
                                    <input type="text" name="phone" class="form-control" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Message</label>
                                    <textarea name="message" rows="5" class="form-control" required></textarea>
                                </div>
                                <div class="col-12">
                                    <button class="btn btn-primary mt-2">
                                        <i class="bi bi-send me-1"></i> Send Message
                                    </button>
                                </div>
                            </div>
                        </form>                        
                    </div>
                </div>
            </div>

            <!-- INFO -->
            <div class="col-lg-5">
                <div class="card contact-card shadow-sm h-100">
                    <div class="card-body p-4 p-md-5">
                        <h4 class="fw-bold mb-4">Contact Information</h4>

                        <div class="info-item">
                            <i class="bi bi-geo-alt-fill"></i>
                            <div>
                                <strong>Address</strong><br>
                                Excellent Grade International School Kubwa. No.1 Reggy Emmanuel Rd., By Mopol Station, Army Scheme Quarters, Kubwa F.C.T Abuja.
                            </div>
                        </div>

                        <div class="info-item">
                            <i class="bi bi-telephone-fill"></i>
                            <div>
                                <strong>Phone</strong><br>
                                +234 800 000 0000
                            </div>
                        </div>

                        <div class="info-item">
                            <i class="bi bi-envelope-fill"></i>
                            <div>
                                <strong>Email</strong><br>
                                support@exgis@gmail.com
                            </div>
                        </div>

                        <hr>
                        <p class="text-muted mb-0">
                            <strong>Office Hours</strong><br>
                            Monday – Friday<br>
                            9:00 AM – 5:00 PM
                        </p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>
<a href="https://wa.me/2348142728873" target="_blank"
style="
position:fixed;
bottom:20px;
right:20px;
background:#25D366;
color:white;
padding:14px 16px;
border-radius:50%;
font-size:22px;
box-shadow:0 10px 20px rgba(0,0,0,0.2);
z-index:999;">
<i class="bi bi-whatsapp"></i>
</a>


<!-- FOOTER -->
<footer class="py-3 text-center">
    <small>© <?= date('Y') ?> EXCELLENTHUB. All Rights Reserved.</small>
</footer>

<script>
const toggle = document.getElementById('darkToggle');
toggle.onclick = () => {
    document.body.classList.toggle('bg-dark');
    document.body.classList.toggle('text-white');
};
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
