<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];

// Fetch assignments for courses the student is subscribed to
$stmt = $pdo->prepare("
    SELECT 
        a.id, 
        a.title, 
        a.description, 
        a.due_date, 
        c.name AS course_name,
        s.id AS submitted
    FROM assignments a
    JOIN courses c ON a.course_id = c.id
    LEFT JOIN assignment_submissions s 
        ON s.assignment_id = a.id AND s.user_id = :uid
    JOIN subscriptions sub 
        ON sub.course_id = a.course_id
    WHERE sub.user_id = :uid
    ORDER BY a.due_date ASC
");
$stmt->execute(['uid' => $user_id]);
$assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);

require_once 'includes/header.php';
?>

<style>
/* ==============================
   ASSIGNMENTS RESPONSIVE STYLES
================================ */

/* Card hover animation */
.hover-shadow {
    transition: all 0.3s ease;
}
.hover-shadow:hover {
    transform: translateY(-5px);
    box-shadow: 0 0.75rem 1.5rem rgba(0,0,0,.15);
}

/* Description clamp */
.assignment-desc {
    font-size: 0.9rem;
    color: #555;
    max-height: 90px;
    overflow: hidden;
}

/* Due date style */
.assignment-due {
    font-size: 0.85rem;
    color: #444;
}

/* Mobile adjustments */
@media (max-width: 768px) {
    h3 {
        text-align: center;
    }

    .assignment-desc {
        max-height: none;
    }

    .card {
        border-radius: 12px;
    }

    .badge {
        align-self: flex-start;
    }
}
</style>

<div class="container mt-5">
    <h3 class="mb-4">📚 My Assignments</h3>

    <div class="row g-4">
        <?php if (empty($assignments)): ?>
            <div class="col-12">
                <div class="alert alert-info text-center">
                    No assignments available at the moment.
                </div>
            </div>
        <?php endif; ?>

        <?php foreach ($assignments as $a): ?>
            <div class="col-sm-12 col-md-6 col-lg-4">
                <div class="card shadow-sm h-100 border-0 hover-shadow">
                    <div class="card-body d-flex flex-column">

                        <h5 class="card-title text-primary mb-2">
                            <?= htmlspecialchars($a['title']) ?>
                        </h5>

                        <p class="mb-1 text-muted small">
                            <strong>Course:</strong> <?= htmlspecialchars($a['course_name']) ?>
                        </p>

                        <p class="assignment-desc mb-2">
                            <?= nl2br(htmlspecialchars($a['description'])) ?>
                        </p>

                        <p class="assignment-due text-end mb-2">
                            <strong>Due:</strong>
                            <?= date('d M Y, H:i', strtotime($a['due_date'])) ?>
                        </p>

                        <?php if ($a['submitted']): ?>
                            <span class="badge bg-success mb-2">Submitted</span>
                            <a href="view_submission.php?id=<?= $a['id'] ?>"
                               class="btn btn-outline-primary btn-sm mt-auto w-100">
                                View Submission
                            </a>
                        <?php else: ?>
                            <span class="badge bg-warning text-dark mb-2">Pending</span>
                            <a href="submit_assignment.php?id=<?= $a['id'] ?>"
                               class="btn btn-warning btn-sm mt-auto w-100">
                                Submit Assignment
                            </a>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<?php 
// require_once 'includes/footer.php'; ?>
