<?php
session_start();

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

require_once '../php/config.php';

$stmt = $pdo->query(
    "SELECT * FROM courses WHERE deleted_at IS NOT NULL"
);
$deletedCourses = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Recycle Bin</title>
    <style>
        body { font-family: Arial; background: #f2f4f7; }
        .container { width: 90%; margin: 40px auto; background: #fff; padding: 20px; border-radius: 8px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 10px; border: 1px solid #ddd; text-align: center; }
        th { background: #dc3545; color: #fff; }
        a.restore { color: #198754; font-weight: bold; text-decoration: none; }
        a.delete { color: #dc3545; font-weight: bold; text-decoration: none; }
    </style>
</head>
<body>
<div class="container">
    <h2>Deleted Courses (Recycle Bin)</h2>

    <table>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Deleted On</th>
            <th>Actions</th>
        </tr>

        <?php foreach ($deletedCourses as $course) { ?>
        <tr>
            <td><?= $course['id'] ?></td>
            <td><?= $course['name'] ?></td>
            <td><?= $course['deleted_at'] ?></td>
            <td>
                <a class="restore" 
                   href="restore_course.php?id=<?= $course['id'] ?>"
                   onclick="return confirm('Restore this course?')">
                   Restore
                </a>
            </td>
        </tr>
        <?php } ?>
    </table>

    <br>
    <a href="courses.php">← Back to Courses</a>
</div>
</body>
</html>
