<?php
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: ../login.php");
    exit;
}

// $stmt = $pdo->query("
//     SELECT * FROM contact_messages
//     ORDER BY created_at DESC
// ");
// $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
<title>Admin | Contact Messages</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-5">
<h3 class="mb-4">📩 Contact Messages</h3>

<table class="table table-bordered bg-white shadow-sm">
<thead class="table-dark">
<tr>
    <th>#</th>
    <th>Name</th>
    <th>Email</th>
    <th>Subject</th>
    <th>Phone</th>
    <th>Message</th>
    <th>Date</th>
</tr>
</thead>
<!-- <tbody> -->
    <tbody id="messagesBody">
<!-- <?php foreach($messages as $i => $m): ?>
<tr>
    <td><?= $i+1 ?></td>
    <td><?= htmlspecialchars($m['name']) ?></td>
    <td><?= htmlspecialchars($m['email']) ?></td>
    <td><?= htmlspecialchars($m['subject']) ?></td>
    <td><?= htmlspecialchars($m['phone'] ?? '') ?></td>
    <td><?= nl2br(htmlspecialchars($m['message'])) ?></td>
    <td><?= date('d M Y h:i A', strtotime($m['created_at'])) ?></td>
</tr>
<?php endforeach; ?> -->
</tbody>
</table>

<a href="dashboard.php" class="btn btn-secondary">⬅ Back</a>
</div>



<audio id="notifySound">
  <source src="../assets/notify.mp3" type="audio/mpeg">
</audio>

<script>
let lastCount = 0;

function fetchMessages() {
    fetch('fetch_messages.php')
        .then(res => res.json())
        .then(data => {
            const tbody = document.getElementById('messagesBody');
            tbody.innerHTML = '';

            // Notify when a new message arrives
            if (lastCount !== 0 && data.length > lastCount) {
                alert('📩 New Contact Message Received!');
                document.getElementById('notifySound').play();
            }

            lastCount = data.length;

            data.forEach((m, i) => {
    tbody.innerHTML += `
    <tr class="${m.is_read == 0 ? 'table-warning' : ''}"
        onclick="markAsRead(${m.id}, this)">

                    <td>${i + 1}</td>
                    <td>${escapeHtml(m.name)}</td>
                    <td>${escapeHtml(m.email)}</td>
                    <td>${escapeHtml(m.subject)}</td>
                    <td>${escapeHtml(m.phone ?? '')}</td>
                    <td>${escapeHtml(m.message).replace(/\n/g, '<br>')}</td>
                    <td>${new Date(m.created_at).toLocaleString()}</td>
                </tr>`;
            });
        });
}

function escapeHtml(text) {
    return text
        ? text.replace(/[&<>"']/g, m => ({
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        }[m]))
        : '';
}

// Load immediately
fetchMessages();

// Repeat every 3 seconds
setInterval(fetchMessages, 3000);



// Mark as read
function markAsRead(id, row) {
    fetch('mark_as_read.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'id=' + id
    });

    // Remove highlight immediately
    row.classList.remove('table-warning');
}

</script>

</body>
</html>
