<?php
// Show all PHP errors in the browser
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once '../php/config.php';

// Admin protection
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

// Fetch courses for dropdown
$courses = $pdo->query("SELECT id, name FROM courses ORDER BY name ASC")->fetchAll();

// Helper: Get Zoom access token
function getZoomAccessToken() {
    $ZOOM_ACCOUNT_ID = 'JvtGh7BsTZqPfBYxHFgbCA';
$ZOOM_CLIENT_ID = '9yQux_GS8CRS9Mxas2UXA';
$ZOOM_CLIENT_SECRET = 'qjGM7cxkg5jd5OkCbY0xou8NQzV01flm';

    $url = "https://zoom.us/oauth/token?grant_type=account_credentials&account_id=" . ZOOM_ACCOUNT_ID;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, ZOOM_CLIENT_ID . ":" . ZOOM_CLIENT_SECRET);
    $response = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($response, true);
    return $data['access_token'] ?? null;
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $course_id = $_POST['course_id'];
    $platform  = $_POST['platform'];
    $start_time = $_POST['start_time']; // yyyy-mm-ddTHH:MM
    $duration   = $_POST['duration'];   // minutes

    $zoomLink = '';
    if ($platform === 'Zoom') {
        $accessToken = getZoomAccessToken();
        if ($accessToken) {
            $meetingData = [
                "topic" => "Class for course ID $course_id",
                "type" => 2,
                "start_time" => date('Y-m-d\TH:i:s', strtotime($start_time)),
                "duration" => (int)$duration,
                "timezone" => "Africa/Lagos",
                "settings" => [
                    "host_video" => true,
                    "participant_video" => true
                ]
            ];

            $zoomUserEmail = 'umohek@gmail.com'; // Must be the account’s email
            $ch = curl_init("https://api.zoom.us/v2/users/$zoomUserEmail/meetings");

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "Authorization: Bearer $accessToken",
                "Content-Type: application/json"
            ]);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($meetingData));

            $response = curl_exec($ch);
            curl_close($ch);

            $meeting = json_decode($response, true);
            $zoomLink = $meeting['join_url'] ?? '';
        }
    }

    // Save to database
    if ($zoomLink) {
        $stmt = $pdo->prepare("INSERT INTO course_links (course_id, platform, link, start_time, duration, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
        $stmt->execute([$course_id, $platform, $zoomLink, $start_time, $duration]);
        header('Location: link_form.php');
        exit;
    } else {
        $error = "Failed to create Zoom meeting. Check your credentials.";
    }
}

// Fetch existing links
$links = $pdo->query("SELECT cl.*, c.name AS course_name FROM course_links cl INNER JOIN courses c ON c.id = cl.course_id ORDER BY cl.created_at DESC")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Schedule Class Link</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">

<div class="container">

    <h3 class="mb-4">Schedule a Class</h3>

    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" class="mb-5">
        <div class="mb-3">
            <label>Course</label>
            <select name="course_id" class="form-select" required>
                <option value="">-- Select Course --</option>
                <?php foreach ($courses as $c): ?>
                    <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Platform</label>
            <select name="platform" class="form-select" required>
                <option value="Zoom">Zoom</option>
            </select>
        </div>

        <div class="mb-3">
            <label>Start Time</label>
            <input type="datetime-local" name="start_time" class="form-control" required>
        </div>

        <div class="mb-3">
            <label>Duration (minutes)</label>
            <input type="number" name="duration" class="form-control" value="60" required>
        </div>

        <button type="submit" class="btn btn-primary">Schedule Meeting</button>
    </form>

    <h4>Scheduled Class Links</h4>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Course</th>
                <th>Platform</th>
                <th>Start Time</th>
                <th>Duration</th>
                <th>Link</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($links as $l): ?>
                <tr>
                    <td><?= $l['id'] ?></td>
                    <td><?= htmlspecialchars($l['course_name']) ?></td>
                    <td><?= htmlspecialchars($l['platform']) ?></td>
                    <td><?= htmlspecialchars($l['start_time']) ?></td>
                    <td><?= htmlspecialchars($l['duration']) ?> mins</td>
                    <td><a href="<?= htmlspecialchars($l['link']) ?>" target="_blank">Join</a></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

</div>

</body>
</html>
