<?php
session_start();

// Check if user is logged in AND is admin
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background-color: #f4f6f9;
        }
        .sidebar {
            min-height: 100vh;
            background: #212529;
        }
        .sidebar a {
            color: #adb5bd;
            text-decoration: none;
            display: block;
            padding: 12px 20px;
            border-radius: 6px;
        }
        .sidebar a:hover, .sidebar a.active {
            background: #0d6efd;
            color: #fff;
        }
        .card-icon {
            font-size: 2rem;
        }
    </style>
</head>

<body>

<div class="container-fluid">
    <div class="row">


        <!-- Sidebar -->
        <div class="col-md-2 sidebar p-3">
            <h4 class="text-white text-center mb-4">
                <i class="bi bi-speedometer2"></i> Admin
            </h4>

            <a href="dashboard.php" class="active">
                <i class="bi bi-house-door"></i> Dashboard
            </a>

            <a href="courses.php">
                <i class="bi bi-journal-bookmark"></i> Manage Courses
            </a>

            <a href="add_modules.php">
                <i class="bi bi-journal-bookmark"></i> add modules
            </a>

            <a href="categories.php">
                <i class="bi bi-tags"></i> Manage Categories
            </a>

            <a href="course_links.php">
                <i class="bi bi-link-45deg"></i> Course Links
            </a>

            <a href="comments.php">
                <i class="bi bi-chat-dots"></i> Comments
            </a>

            <a href="subscriptions.php">
                <i class="bi bi-people"></i> Subscriptions
            </a>

            <a href="logout.php" class="text-danger">
                <i class="bi bi-box-arrow-right"></i> Logout
            </a>
        </div>

        <!-- Main Content -->
        <div class="col-md-10 p-4">

            <h2 class="fw-bold mb-4">
                Welcome, <?= htmlspecialchars($_SESSION['user']['fullname']) ?>
            </h2>

            <div class="row g-4">
                <!-- ADD COURSE -->
<div class="col-md-3">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <i class="bi bi-plus-circle card-icon text-primary"></i>
            <h5 class="mt-2">Add Course</h5>
            <a href="add_courses.php" class="btn btn-outline-primary btn-sm mt-2">
                Create
            </a>
        </div>
    </div>
</div>

<div class="col-md-3">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <i class="bi bi-plus-square card-icon text-success"></i>
            <h5 class="mt-2">Add Module</h5>
            <a href="add_modules.php" class="btn btn-outline-success btn-sm mt-2">
                Add Module
            </a>
        </div>
    </div>
</div>

                <div class="col-md-3">
                    <div class="card shadow-sm">
                        <div class="card-body text-center">
                            <i class="bi bi-journal-bookmark card-icon text-primary"></i>
                            <h5 class="mt-2">Manage Courses</h5>
                            <a href="courses.php" class="btn btn-outline-primary btn-sm mt-2">
                                Manage
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="card shadow-sm">
                        <div class="card-body text-center">
                            <i class="bi bi-link-45deg card-icon text-success"></i>
                            <h5 class="mt-2">Course Links</h5>
                            <a href="course_links.php" class="btn btn-outline-success btn-sm mt-2">
                                View
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="card shadow-sm">
                        <div class="card-body text-center">
                            <i class="bi bi-chat-dots card-icon text-warning"></i>
                            <h5 class="mt-2">Comments</h5>
                            <a href="comments.php" class="btn btn-outline-warning btn-sm mt-2">
                                Moderate
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="card shadow-sm">
                        <div class="card-body text-center">
                            <i class="bi bi-people card-icon text-danger"></i>
                            <h5 class="mt-2">Subscriptions</h5>
                            <a href="subscriptions.php" class="btn btn-outline-danger btn-sm mt-2">
                                View
                            </a>
                        </div>
                    </div>
                </div>


                <!-- CBT / ASSESSMENT MANAGEMENT -->
<div class="col-md-3">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <i class="bi bi-ui-checks card-icon text-primary"></i>
            <h5 class="mt-2">Assessments</h5>
            <a href="assessments.php" class="btn btn-outline-primary btn-sm mt-2">
                View
            </a>
        </div>
    </div>
</div>


<div class="col-md-3">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <i class="bi bi-question-circle card-icon text-warning"></i>
            <h5 class="mt-2">Add Questions</h5>
            <a href="add_questions.php" class="btn btn-outline-warning btn-sm mt-2">
                Manage
            </a>
        </div>
    </div>
</div>

<!-- RESULTS MANAGEMENT -->
<div class="col-md-3">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <i class="bi bi-bar-chart-line card-icon text-info"></i>
            <h5 class="mt-2">Results</h5>
            <a href="results.php" class="btn btn-outline-info btn-sm mt-2">
                View Results
            </a>
        </div>
    </div>
</div>

<!-- Add Assignment Card -->
<div class="col-12 col-md-3 mb-3">
    <div class="card shadow-sm h-100 text-center">
        <div class="card-body d-flex flex-column justify-content-center align-items-center">
            <i class="bi bi-plus-circle fs-1 text-success mb-2"></i>
            <h5 class="card-title mb-2">Add Assignment</h5>
            <a href="add_assignment.php" class="btn btn-outline-success btn-sm">
                Create New
            </a>
        </div>
    </div>
</div>


<!-- Assignment Grading Card -->
<div class="col-12 col-md-3 mb-3">
    <div class="card shadow-sm h-100 text-center">
        <div class="card-body d-flex flex-column justify-content-center align-items-center">
            <i class="bi bi-clipboard-check fs-1 text-info mb-2"></i>
            <h5 class="card-title mb-2">View Assignment</h5>
            <a href="assignments.php" class="btn btn-outline-info btn-sm">
                View Now
            </a>
        </div>
    </div>
</div>

<div class="col-12 col-md-3 mb-3">
    <div class="card shadow-sm h-100 text-center">
        <div class="card-body d-flex flex-column justify-content-center align-items-center">
            <i class="bi bi-clipboard-check fs-1 text-info mb-2"></i>
            <h5 class="card-title mb-2">View Contact messages</h5>
            <a href="messages.php" class="btn btn-outline-info btn-sm">
                View Now
            </a>
        </div>
    </div>
</div>



<!-- PAYMENTS -->
<div class="col-md-3">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <i class="bi bi-cash-coin card-icon text-danger"></i>
            <h5 class="mt-2">Manual Payments</h5>
            <a href="admin_manual_payment.php" class="btn btn-outline-danger btn-sm mt-2">
                Approve
            </a>
        </div>
    </div>
</div>


<div class="col-md-3">
    <div class="card shadow-sm">
        <div class="card-body text-center">
            <i class="bi bi-plus-square card-icon text-success"></i>
            <h5 class="mt-2">Recover Deleted file</h5>
            <a href="recycle_bin.php" class="btn btn-outline-success btn-sm mt-2">
                Recover
            </a>
        </div>
    </div>
</div>


            </div>

        </div>

    </div>
</div>

</body>
</html>
