<?php
session_start();
// if (!isset($_SESSION['admin'])) {
//     header('Location: login.php');
//     exit;
// }

// Optional admin protection
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

require_once '../php/config.php';
// $stmt = $pdo->query('SELECT * FROM courses');

$stmt = $pdo->query("SELECT * FROM courses WHERE deleted_at IS NULL");

$courses = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Manage Courses</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f2f4f7;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 90%;
            max-width: 1000px;
            margin: 50px auto;
            background: #fff;
            padding: 20px 30px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            border-radius: 8px;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table th, table td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: center;
        }
        table th {
            background: #0d6efd;
            color: #fff;
        }
        table tr:nth-child(even) {
            background: #f9f9f9;
        }
        table tr:hover {
            background: #e0e0e0;
        }
        a.button {
            display: inline-block;
            padding: 10px 20px;
            background: #198754;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 20px;
        }
        a.button:hover {
            background: #146c43;
        }
        a.action {
            margin: 0 5px;
            color: #0d6efd;
            text-decoration: none;
            font-weight: bold;
        }
        a.action:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Manage Courses</h2>
    <table>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Level</th>
            <!-- <th>Type</th> -->
            <th>Duration</th>
            <th>Price</th>
            <th>File</th>
            <th>Actions</th>
        </tr>
        <?php foreach ($courses as $course) { ?>
        <tr>
            <td><?= $course['id'] ?></td>
            <td><?= $course['name'] ?></td>
            <td><?= $course['level'] ?></td>

            <td><?= $course['duration'] ?> days</td>
            <td><?= $course['price'] ?></td>
     

<td>
    <video width="150" controls>
        <source src="../courses/<?= $course['file'] ?>" type="video/mp4">
    </video>
</td>


            <td>
                <a class="action" href="edit_course.php?id=<?= $course['id'] ?>">Edit</a>
                <a class="action" 
   href="delete_course.php?id=<?= $course['id'] ?>" 
   onclick="return confirm('Are you sure you want to delete this course?')">
   Delete
</a>

            </td>
        </tr>
        <?php } ?>
    </table>
    <a class="button" href="add_course.php">Add Course</a>
    <a class="button" style="background:#dc3545" href="recycle_bin.php">
    Recycle Bin
</a>

</div>
</body>
</html>
