<?php
require_once '../Config.php';
require_once 'includes/header.php';

$id = $_GET['id'] ?? 0;
$course = ['name'=>'','description'=>'','level'=>'','file'=>'','thumbnail'=>''];

if($id){
    $stmt = $pdo->prepare("SELECT * FROM courses WHERE id=?");
    $stmt->execute([$id]);
    $course = $stmt->fetch(PDO::FETCH_ASSOC);
}

if($_SERVER['REQUEST_METHOD']==='POST'){
    $name = $_POST['name'];
    $desc = $_POST['description'];
    $level = $_POST['level'];

    // Upload files
    $file_name = $_FILES['file']['name'] ?? $course['file'];
    if(isset($_FILES['file']) && $_FILES['file']['tmp_name']){
        move_uploaded_file($_FILES['file']['tmp_name'], "../courses/".$_FILES['file']['name']);
        $file_name = $_FILES['file']['name'];
    }

    $thumb_name = $_FILES['thumbnail']['name'] ?? $course['thumbnail'];
    if(isset($_FILES['thumbnail']) && $_FILES['thumbnail']['tmp_name']){
        move_uploaded_file($_FILES['thumbnail']['tmp_name'], "../assets/uploads/".$_FILES['thumbnail']['name']);
        $thumb_name = $_FILES['thumbnail']['name'];
    }

    if($id){
        $stmt = $pdo->prepare("UPDATE courses SET name=?, description=?, level=?, file=?, thumbnail=? WHERE id=?");
        $stmt->execute([$name,$desc,$level,$file_name,$thumb_name,$id]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO courses(name,description,level,file,thumbnail) VALUES(?,?,?,?,?)");
        $stmt->execute([$name,$desc,$level,$file_name,$thumb_name]);
    }
    header("Location: courses.php");
    exit;
}
?>

<h4><?= $id ? 'Edit' : 'Add' ?> Course</h4>
<form method="post" enctype="multipart/form-data">
    <div class="mb-3">
        <label>Name</label>
        <input type="text" name="name" value="<?= htmlspecialchars($course['name']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>Description</label>
        <textarea name="description" class="form-control"><?= htmlspecialchars($course['description']) ?></textarea>
    </div>
    <div class="mb-3">
        <label>Level</label>
        <input type="text" name="level" value="<?= htmlspecialchars($course['level']) ?>" class="form-control">
    </div>
    <div class="mb-3">
        <label>Video File</label>
        <input type="file" name="file" class="form-control">
    </div>
    <div class="mb-3">
        <label>Thumbnail</label>
        <input type="file" name="thumbnail" class="form-control">
    </div>
    <button class="btn btn-primary"><?= $id ? 'Update' : 'Add' ?></button>
</form>

<?php require_once 'includes/footer.php'; ?>
