<?php
session_start();
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

require_once '../php/config.php';

// Handle Add Category
if (isset($_POST['add'])) {
    $name = $_POST['name'];
    if (!empty($name)) {
        $stmt = $pdo->prepare("INSERT INTO categories(name) VALUES(:name)");
        $stmt->execute(['name' => $name]);
        header('Location: categories.php');
        exit;
    } else {
        $error = "Category name cannot be empty.";
    }
}

// Handle Delete Category
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM categories WHERE id=:id");
    $stmt->execute(['id' => $id]);
    header('Location: categories.php');
    exit;
}

// Fetch all categories
$stmt = $pdo->query("SELECT * FROM categories");
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Manage Categories</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f2f4f7;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 700px;
            max-width: 90%;
            margin: 50px auto;
            background: #fff;
            padding: 20px 30px;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            border-radius: 8px;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table th, table td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: center;
        }
        table th {
            background: #0d6efd;
            color: #fff;
        }
        table tr:nth-child(even) {
            background: #f9f9f9;
        }
        table tr:hover {
            background: #e0e0e0;
        }
        a.button {
            display: inline-block;
            padding: 10px 20px;
            background: #198754;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
            margin: 15px 0;
        }
        a.button:hover {
            background: #146c43;
        }
        a.action {
            margin: 0 5px;
            color: #0d6efd;
            text-decoration: none;
            font-weight: bold;
        }
        a.action:hover {
            text-decoration: underline;
        }
        form {
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
        }
        form input[type="text"] {
            width: 70%;
            padding: 10px;
            border-radius: 4px;
            border: 1px solid #ddd;
        }
        form button {
            width: 25%;
            padding: 10px;
            background: #0d6efd;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        form button:hover {
            background: #0a58ca;
        }
        .error {
            background: #ffdddd;
            padding: 10px;
            border-left: 4px solid red;
            margin-bottom: 15px;
            color: #b10000;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Manage Categories</h2>

    <?php if (isset($error)) { ?>
        <div class="error"><?= $error ?></div>
    <?php } ?>

    <!-- Add Category Form -->
    <form method="post">
        <input type="text" name="name" placeholder="New Category Name" required>
        <button type="submit" name="add">Add Category</button>
    </form>

    <!-- Categories Table -->
    <table>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Actions</th>
        </tr>
        <?php foreach ($categories as $category) { ?>
        <tr>
            <td><?= $category['id'] ?></td>
            <td><?= $category['name'] ?></td>
            <td>
                <a class="action" href="edit_category.php?id=<?= $category['id'] ?>">Edit</a>
                <a class="action" href="categories.php?delete=<?= $category['id'] ?>" onclick="return confirm('Are you sure?')">Delete</a>
            </td>
        </tr>
        <?php } ?>
    </table>
</div>
</body>
</html>
