<?php
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';

if ($_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$assignments = $pdo->query("
    SELECT a.id, a.title, a.due_date, c.name AS course_name
    FROM assignments a
    LEFT JOIN courses c ON a.course_id = c.id
    ORDER BY a.due_date DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-5">
<h3>All Assignments</h3>
<a href="add_assignment.php" class="btn btn-success mb-3">➕ Add Assignment</a>

<table class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>#</th>
            <th>Title</th>
            <th>Course</th>
            <th>Due Date</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($assignments as $i => $a): ?>
        <tr>
            <td><?= $i+1 ?></td>
            <td><?= htmlspecialchars($a['title']) ?></td>
            <td><?= htmlspecialchars($a['course_name']) ?></td>
            <td><?= htmlspecialchars($a['due_date']) ?></td>
            <td>
                <a href="grade_assignment.php?id=<?= $a['id'] ?>" class="btn btn-primary btn-sm">
                    📝 Grade Submissions
                </a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
</div>
