<?php
require_once '../Config.php';

// Approve a manual payment
if (isset($_GET['approve_id'])) {
    $id = intval($_GET['approve_id']);
    $stmt = $pdo->prepare("UPDATE subscriptions SET payment_status = 'paid' WHERE id = :id AND payment_method = 'manual'");
    $stmt->execute(['id' => $id]);
    header("Location: admin_manual_payments.php");
    exit;
}

// Fetch all manual subscriptions that are pending
$stmt = $pdo->prepare("SELECT s.id, s.user_id, s.course_id, s.amount, s.reference, s.start_date, s.end_date, u.email, c.name AS course_name 
                       FROM subscriptions s
                       JOIN users u ON s.user_id = u.id
                       JOIN courses c ON s.course_id = c.id
                       WHERE s.payment_method = 'manual' AND s.payment_status = 'pending'
                       ORDER BY s.id DESC");
$stmt->execute();
$manual_subscriptions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin - Manual Payments</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
    <div class="container">
        <h2>Pending Manual Payments</h2>
        <?php if (count($manual_subscriptions) === 0): ?>
            <div class="alert alert-info">No pending manual payments.</div>
        <?php else: ?>
            <table class="table table-bordered table-striped mt-3">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User Email</th>
                        <th>Course</th>
                        <th>Amount (₦)</th>
                        <th>Reference</th>
                        <th>Subscription Period</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($manual_subscriptions as $sub): ?>
                        <tr>
                            <td><?= $sub['id'] ?></td>
                            <td><?= htmlspecialchars($sub['email']) ?></td>
                            <td><?= htmlspecialchars($sub['course_name']) ?></td>
                            <td><?= number_format($sub['amount']) ?></td>
                            <td><?= htmlspecialchars($sub['reference']) ?></td>
                            <td><?= $sub['start_date'] ?> to <?= $sub['end_date'] ?></td>
                            <td>
                                <a href="?approve_id=<?= $sub['id'] ?>" class="btn btn-success btn-sm" onclick="return confirm('Mark this subscription as paid?')">
                                    Approve Payment
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</body>
</html>
