<?php 
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';

// Ensure admin is logged in
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$aid = $_GET['id'] ?? null;

// Fetch assessment details along with course and category
$assessmentTitle = $courseTitle = $categoryTitle = '';
if ($aid) {
    $stmt = $pdo->prepare("
        SELECT a.assessment_title AS assessment_title, c.name AS course_name, cat.name AS category_name
        FROM assessments a
        LEFT JOIN courses c ON a.course_id = c.id
        LEFT JOIN categories cat ON c.category_id = cat.id
        WHERE a.id = ?
    ");
    $stmt->execute([$aid]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row) {
        $assessmentTitle = $row['assessment_title'];
        $courseTitle = $row['course_name'];
        $categoryTitle = $row['category_name'];
    }
}

$successMsg = '';
$errorMsg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $question = trim($_POST['q']);
    $a = trim($_POST['a']);
    $b = trim($_POST['b']);
    $c = trim($_POST['c']);
    $d = trim($_POST['d']);
    $ans = $_POST['ans'] ?? '';
    $explanation_correct = trim($_POST['explanation_correct'] ?? '');
    $explanation_wrong = trim($_POST['explanation_wrong'] ?? '');

    if (!$question || !$a || !$b || !$c || !$d || !$ans) {
        $errorMsg = "Please fill in all fields and select the correct answer.";
    } else {
        $stmt = $pdo->prepare("
            INSERT INTO questions
            (assessment_id, question, option_a, option_b, option_c, option_d, correct_option, explanation_correct, explanation_wrong)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$aid, $question, $a, $b, $c, $d, $ans, $explanation_correct, $explanation_wrong]);
        $successMsg = "✅ Question added successfully!";
    }
}
?>

<div class="container mt-4">
    <h3 class="mb-3">
        Add Question to Assessment: 
        <?= htmlspecialchars($assessmentTitle ?: "ID #$aid") ?>
    </h3>

    <?php if ($courseTitle || $categoryTitle): ?>
        <div class="mb-3">
            <strong>Course:</strong> <?= htmlspecialchars($courseTitle ?: '-') ?><br>
            <strong>Category:</strong> <?= htmlspecialchars($categoryTitle ?: '-') ?>
        </div>
    <?php endif; ?>

    <?php if ($successMsg): ?>
        <div class="alert alert-success"><?= htmlspecialchars($successMsg) ?></div>
    <?php endif; ?>
    <?php if ($errorMsg): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($errorMsg) ?></div>
    <?php endif; ?>

    <form method="post" class="card p-4 shadow-sm">
        <div class="mb-3">
            <label for="q" class="form-label">Question</label>
            <textarea name="q" id="q" class="form-control" rows="3" required><?= htmlspecialchars($_POST['q'] ?? '') ?></textarea>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="a" class="form-label">Option A</label>
                <input type="text" name="a" id="a" class="form-control" value="<?= htmlspecialchars($_POST['a'] ?? '') ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="b" class="form-label">Option B</label>
                <input type="text" name="b" id="b" class="form-control" value="<?= htmlspecialchars($_POST['b'] ?? '') ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="c" class="form-label">Option C</label>
                <input type="text" name="c" id="c" class="form-control" value="<?= htmlspecialchars($_POST['c'] ?? '') ?>" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="d" class="form-label">Option D</label>
                <input type="text" name="d" id="d" class="form-control" value="<?= htmlspecialchars($_POST['d'] ?? '') ?>" required>
            </div>
        </div>

        <div class="mb-3">
            <label for="ans" class="form-label">Correct Answer</label>
            <select name="ans" id="ans" class="form-select" required>
                <option value="" disabled selected>Select the correct answer</option>
                <option value="a" <?= (($_POST['ans'] ?? '') === 'a') ? 'selected' : '' ?>>A</option>
                <option value="b" <?= (($_POST['ans'] ?? '') === 'b') ? 'selected' : '' ?>>B</option>
                <option value="c" <?= (($_POST['ans'] ?? '') === 'c') ? 'selected' : '' ?>>C</option>
                <option value="d" <?= (($_POST['ans'] ?? '') === 'd') ? 'selected' : '' ?>>D</option>
            </select>
        </div>

        <div class="mb-3">
            <label for="explanation_correct" class="form-label">Explanation (if correct)</label>
            <textarea name="explanation_correct" id="explanation_correct" class="form-control" rows="2"><?= htmlspecialchars($_POST['explanation_correct'] ?? '') ?></textarea>
        </div>

        <div class="mb-3">
            <label for="explanation_wrong" class="form-label">Explanation (if wrong)</label>
            <textarea name="explanation_wrong" id="explanation_wrong" class="form-control" rows="2"><?= htmlspecialchars($_POST['explanation_wrong'] ?? '') ?></textarea>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-success">💾 Save Question</button>
            <a href="questions.php?id=<?= htmlspecialchars((string)$aid) ?>" class="btn btn-secondary">⬅ Back to Questions</a>
        </div>
    </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
