<?php
session_start();
require_once '../php/config.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $course_id = $_POST['course_id'] ?? '';
    $title = trim($_POST['title'] ?? '');
    $is_free = isset($_POST['is_free']) ? 1 : 0;
    $module_order = (int)($_POST['module_order'] ?? 1);

    $video_file = null;

    if (!empty($_FILES['video']['name'])) {
        $videoExt = strtolower(pathinfo($_FILES['video']['name'], PATHINFO_EXTENSION));
        $allowedVideos = ['mp4','avi','mov','mkv'];

        if (!in_array($videoExt, $allowedVideos)) {
            $error = 'Invalid video format.';
        } else {
            $video_file = uniqid('module_') . '.' . $videoExt;
            $videoPath = realpath(__DIR__ . '/..') . '/courses/' . $video_file;
            if (!move_uploaded_file($_FILES['video']['tmp_name'], $videoPath)) {
                $error = 'Video upload failed.';
            }
        }
    } else {
        $error = 'Please upload a video.';
    }

    if ($error === '') {
        $stmt = $pdo->prepare("INSERT INTO course_modules (course_id, title, video_file, module_order, is_free) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$course_id, $title, $video_file, $module_order, $is_free]);
        $success = 'Module added successfully!';
    }
}

// Fetch all courses
$courses = $pdo->query("SELECT id, name FROM courses ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add Module</title>
<style>
body { font-family: Arial; background:#f2f4f7; margin:0; padding:0; }
.container { max-width:700px; margin:50px auto; background:#fff; padding:25px; border-radius:8px; box-shadow:0 5px 15px rgba(0,0,0,.1); }
h2 { text-align:center; margin-bottom:20px; }
form { display:flex; flex-direction:column; gap:15px; }
input, select { padding:10px; border:1px solid #ccc; border-radius:5px; }
button { padding:12px; background:#0d6efd; color:#fff; border:none; border-radius:5px; cursor:pointer; }
button:hover { background:#084298; }
.success { background:#ddffdd; padding:10px; border-left:4px solid green; color:#006400; }
.error { background:#ffe5e5; padding:10px; border-left:4px solid red; color:#a30000; }
</style>
</head>
<body>
<div class="container">
<h2>➕ Add Module</h2>

<?php if($error): ?>
    <div class="error"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>
<?php if($success): ?>
    <div class="success"><?= htmlspecialchars($success) ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data">
    <label>Course</label>
    <select name="course_id" required>
        <option value="">-- Select Course --</option>
        <?php foreach($courses as $c): ?>
            <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
        <?php endforeach; ?>
    </select>

    <label>Module Title</label>
    <input type="text" name="title" required>

    <label>Module Video</label>
    <input type="file" name="video" accept="video/*" required>

    <label>Module Order (1, 2, 3…)</label>
    <input type="number" name="module_order" required>

    <label><input type="checkbox" name="is_free"> Free Module (Preview)</label>

    <button type="submit">Add Module</button>
</form>
</div>
</body>
</html>
