<?php
session_start();
error_reporting(0);
ini_set('display_errors', 0);
set_time_limit(300);
date_default_timezone_set('Africa/Lagos');

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

require_once '../php/config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name = trim($_POST['name'] ?? '');
    $level = trim($_POST['level'] ?? '');
    $duration = (int)($_POST['duration'] ?? 0);
    $price = (float)($_POST['price'] ?? 0);
    $category_id = $_POST['category_id'] ?: null;
    $target_exams = trim($_POST['target_exams'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $has_assign = isset($_POST['has_assignments']) ? 1 : 0;

    $fileName = null;
    $thumbnailName = null;

    /* VIDEO UPLOAD */
    if (!empty($_FILES['file']['name'])) {

        if ($_FILES['file']['size'] > (1000000 * 1024 * 1024)) {
            $error = 'Video too large. Max 100MB allowed.';
        } else {

            $videoExt = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
            $allowedVideos = ['mp4', 'avi', 'mov', 'mkv'];

            if (!in_array($videoExt, $allowedVideos)) {
                $error = 'Invalid video format.';
            } else {
                $fileName = uniqid('video_') . '.' . $videoExt;
                $videoPath = realpath(__DIR__ . '/..') . '/courses/' . $fileName;

                if (!move_uploaded_file($_FILES['file']['tmp_name'], $videoPath)) {
                    $error = 'Video upload failed.';
                }
            }
        }
    } else {
        $error = 'Please upload a video.';
    }

    /* THUMBNAIL */
    if ($error === '' && !empty($_FILES['thumbnail']['name'])) {

        $thumbExt = strtolower(pathinfo($_FILES['thumbnail']['name'], PATHINFO_EXTENSION));
        $allowedThumbs = ['jpg','jpeg','png','webp'];

        if (!in_array($thumbExt, $allowedThumbs)) {
            $error = 'Invalid thumbnail format.';
        } else {
            $thumbnailName = uniqid('thumb_') . '.' . $thumbExt;
            $thumbPath = realpath(__DIR__ . '/..') . '/assets/uploads/' . $thumbnailName;

            if (!move_uploaded_file($_FILES['thumbnail']['tmp_name'], $thumbPath)) {
                $error = 'Thumbnail upload failed.';
            }
        }
    }

    /* INSERT */
    if ($error === '') {

        $stmt = $pdo->prepare("
            INSERT INTO courses
            (category_id, name, target_exams, description, thumbnail, file, level, duration, price, has_assignments, created_by)
            VALUES (?,?,?,?,?,?,?,?,?,?,?)
        ");

        $stmt->execute([
            $category_id, $name, $target_exams, $description,
            $thumbnailName, $fileName, $level,
            $duration, $price, $has_assign, $_SESSION['user']['id']
        ]);

$course_id = $pdo->lastInsertId();


// Notify subscribed students
$subs = $pdo->prepare("SELECT user_id FROM subscriptions WHERE course_id = ?");
$subs->execute([$course_id]);
$users = $subs->fetchAll(PDO::FETCH_COLUMN);

foreach($users as $uid){
    $notify = $pdo->prepare("
        INSERT INTO notifications (user_id, title, message, link)
        VALUES (?, ?, ?, ?)
    ");
    $notify->execute([
        $uid,
        '📚 New Course Added',
        "A new course \"$name\" has been added.",
        'index1.php'
    ]);
}


        header('Location: courses.php?success=1');
        exit;
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Add Course</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body {
    font-family: Arial, sans-serif;
    background: #f2f4f7;
    margin: 0;
    padding: 0;
}
.container {
    max-width: 1000px;
    background: #fff;
    margin: 60px auto;
    padding: 30px;
    box-shadow: 0 10px 25px rgba(0,0,0,.15);
    border-radius: 10px;
}
h2 {
    text-align: center;
    margin-bottom: 25px;
}
form {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}
.form-group {
    flex: 1 1 45%;
    display: flex;
    flex-direction: column;
}
.form-group-full {
    flex: 1 1 100%;
}
label {
    font-weight: 600;
    margin-bottom: 6px;
}
input, select, textarea {
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 5px;
}
textarea {
    resize: vertical;
    min-height: 90px;
}
button {
    width: 100%;
    padding: 14px;
    background: #0d6efd;
    color: #fff;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    cursor: pointer;
}
button:hover {
    background: #084298;
}
.error {
    background: #ffe5e5;
    padding: 12px;
    border-left: 4px solid #dc3545;
    margin-bottom: 20px;
    color: #a30000;
}
</style>
</head>

<body>

<div class="container">
    <h2>➕ Add New Course</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">

        <div class="form-group">
            <label>Course Title</label>
            <input type="text" name="name" required>
        </div>

        <div class="form-group">
            <label>Target Exams</label>
            <input type="text" name="target_exams">
        </div>

        <div class="form-group">
            <label>Level</label>
            <input type="text" name="level">
        </div>

        <div class="form-group">
            <label>Duration (Days)</label>
            <input type="number" name="duration">
        </div>

        <div class="form-group">
            <label>Price (₦)</label>
            <input type="number" step="0.01" name="price">
        </div>

        <div class="form-group">
            <label>Category</label>
            <select name="category_id">
                <option value="">-- Select --</option>
                <?php
                $cats = $pdo->query("SELECT * FROM categories")->fetchAll(PDO::FETCH_ASSOC);
                foreach ($cats as $cat) {
                    echo "<option value='{$cat['id']}'>" . htmlspecialchars($cat['name']) . "</option>";
                }
                ?>
            </select>
        </div>

        <div class="form-group-full">
            <label>Description</label>
            <textarea name="description"></textarea>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="has_assignments"> Has Assignments
            </label>
        </div>

        <div class="form-group">
            <label>Course Video</label>
            <input type="file" name="file" accept="video/*" required>
        </div>

        <div class="form-group">
            <label>Thumbnail Image</label>
            <input type="file" name="thumbnail" accept="image/*" required>
        </div>

        <div class="form-group-full">
            <button type="submit">Save Course</button>
        </div>

    </form>
</div>

</body>
</html>
