<?php
session_start();

// Redirect if admin not logged in
// if (!isset($_SESSION['admin'])) {
//     header('Location: login.php');
//     exit;
// }

// Optional admin protection
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

require_once '../php/config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Collect form data
    $name         = $_POST['name'] ?? '';
    // $subject      = $_POST['subject'] ?? '';
    $level        = $_POST['level'] ?? '';
    // $type         = $_POST['type'] ?? '';
    $duration     = ($_POST['duration'] ?? 0);
    $price        = (float)($_POST['price'] ?? 0);
    $category_id  = $_POST['category_id'] ?? null;
    $target_exams = $_POST['target_exams'] ?? '';
    $description  = $_POST['description'] ?? '';
    $has_assign   = isset($_POST['has_assignments']) ? 1 : 0;

    // Handle curriculum file (video)
    $fileName = null;
    $thumbnailName = null;

    if (!empty($_FILES['file']['name'])) {
        $tmp = $_FILES['file']['tmp_name'];
        $ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
        $allowed_ext = ['mp4','avi','mov','mkv'];

        if (in_array($ext, $allowed_ext)) {
            $fileName = uniqid('file_').'.'.$ext;
            $fileDestination = __DIR__.'/../courses/'.$fileName;

            if (move_uploaded_file($tmp, $fileDestination)) {
                // Generate thumbnail from video using ffmpeg
                $thumbnailName = uniqid('thumb_').'.jpg';
                $thumbnailPath = __DIR__.'/../assets/uploads/'.$thumbnailName;

                // Capture a frame at 3 seconds
                $cmd = "ffmpeg -i " . escapeshellarg($fileDestination) . " -ss 00:00:03 -vframes 1 " . escapeshellarg($thumbnailPath);
                exec($cmd);
            } else {
                $error = 'Failed to move uploaded video.';
            }
        } else {
            $error = 'Invalid video type. Allowed: mp4, avi, mov, mkv';
        }
    } else {
        $error = 'Please upload a course video.';
    }

    // Insert into database if no error
    if ($error === '') {
        $stmt = $pdo->prepare('INSERT INTO courses 
            (category_id, name, target_exams, description, thumbnail, file, level, duration, price, has_assignments, created_by) 
            VALUES 
            (:category_id, :name, :target_exams, :description, :thumbnail, :file, :level, :duration, :price, :has_assignments, :created_by)');

        $stmt->execute([
            ':category_id'     => $category_id,
            ':name'            => $name,
            // ':subject'         => $subject,
            ':target_exams'    => $target_exams,
            ':description'     => $description,
            ':thumbnail'       => $thumbnailName,
            ':file'            => $fileName,
            ':level'           => $level,
            // ':type'            => $type,
            ':duration'        => $duration,
            ':price'           => $price,
            ':has_assignments' => $has_assign,
            ':created_by'      => $_SESSION['user']['id'] ?? null
        ]);

        header('Location: courses.php');
        exit;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Course</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            background: #f2f4f7; 
            margin:0; 
            padding:0; 
        }
        .container { 
            width: 90%; 
            max-width: 1000px; 
            background: white; 
            margin: 60px auto; 
            padding: 30px; 
            box-shadow: 0 0 15px rgba(0,0,0,0.2); 
            border-radius: 8px; 
            display: flex; 
            flex-wrap: wrap;
            gap: 20px;
        }
        h2 { 
            width: 100%; 
            text-align: center; 
            color: #333; 
            margin-bottom: 20px;
        }
        form { 
            display: flex; 
            flex-wrap: wrap; 
            gap: 20px; 
            width: 100%;
        }
        .form-group { 
            flex: 1 1 45%; 
            display: flex; 
            flex-direction: column; 
        }
        .form-group-full { 
            flex: 1 1 100%; 
        }
        label { 
            font-weight: bold; 
            margin-bottom: 5px; 
        }
        input, select, textarea { 
            padding: 10px; 
            border: 1px solid #ddd; 
            border-radius: 4px; 
            font-size: 14px;
        }
        textarea { resize: vertical; min-height: 80px; }
        button { 
            display: block; 
            width: 100%; 
            padding: 12px; 
            background:#0d6efd; 
            border:none; 
            border-radius:4px; 
            margin-top: 20px; 
            color:white; 
            font-size:16px; 
            cursor:pointer; 
        }
        button:hover { background:#0a58ca; }
        .error { 
            background:#ffdddd; 
            padding:10px; 
            border-left:4px solid red; 
            margin-bottom:15px; 
            color:#b10000; 
            width: 100%;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Add Course</h2>

    <?php if(isset($error) && $error != ''): ?>
        <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">
        <div class="form-group">
            <label>Title:</label>
            <input type="text" name="name" required>
        </div>

<!--         <div class="form-group">
            <label>Subject:</label>
            <input type="text" name="subject">
        </div> -->

        <div class="form-group">
            <label>Scope:</label>
            <input type="text" name="target_exams">
        </div>

        <div class="form-group">
            <label>Level:</label>
            <input type="text" name="level">
        </div>

<!--         <div class="form-group">
            <label>Type:</label>
            <input type="text" name="type">
        </div> -->

        <div class="form-group">
            <label>Duration (days):</label>
            <input type="text" name="duration">
        </div>

        <div class="form-group">
            <label>Price:</label>
            <input type="number" name="price" step="0.01">
        </div>

        <div class="form-group">
            <label>Category:</label>
            <select name="category_id">
                <option value="">--Select--</option>
                <?php
                $stmt = $pdo->query('SELECT * FROM categories');
                $categories = $stmt->fetchAll();
                foreach($categories as $cat){
                    echo "<option value='{$cat['id']}'>{$cat['name']}</option>";
                }
                ?>
            </select>
        </div>

        <div class="form-group-full">
            <label>Description:</label>
            <textarea name="description"></textarea>
        </div>

        <div class="form-group">
            <label>Has Assignments:</label>
            <input type="checkbox" name="has_assignments">
        </div>

        <div class="form-group">
            <label>Course Video:</label>
            <input type="file" name="file" required>
        </div>

        <div class="form-group-full">
            <button type="submit">Add Course</button>
        </div>
    </form>
</div>
</body>
</html>

