<?php
require_once __DIR__ . '/../php/config.php';
require_once __DIR__ . '/../includes/header.php';

// Ensure admin is logged in
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

// Fetch all courses for dropdown
$courseStmt = $pdo->query("SELECT id, name FROM courses ORDER BY name ASC");
$courses = $courseStmt->fetchAll(PDO::FETCH_ASSOC);

// $successMsg = '';
$successMsg = '';
if (isset($_GET['success'])) {
    $successMsg = "✅ Assignment created successfully!";
}

$errorMsg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $course_id = $_POST['course_id'] ?? '';
    $due_date = $_POST['due_date'] ?? '';

    if (!$title || !$description || !$course_id || !$due_date) {
        $errorMsg = "Please fill in all fields.";
    } else {
        $stmt = $pdo->prepare("
            INSERT INTO assignments (title, description, course_id, due_date)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([$title, $description, $course_id, $due_date]);


$subs = $pdo->prepare("SELECT user_id FROM subscriptions WHERE course_id = ?");
$subs->execute([$course_id]);
$users = $subs->fetchAll(PDO::FETCH_COLUMN);

foreach($users as $uid){
    $notify = $pdo->prepare("
        INSERT INTO notifications (user_id, title, message, link)
        VALUES (?, ?, ?, ?)
    ");
    $notify->execute([
        $uid,
        '📂 New Assignment Added',
        "Assignment \"$title\" has been added.",
        'assignments.php'
    ]);
}



        // $successMsg = "✅ Assignment created successfully!";
        // Redirect to avoid double submission
header("Location: add_assignment.php?success=1");
exit;

    }
}
?>

<div class="container mt-5">
    <h3>Add Assignment</h3>

    <?php if ($successMsg): ?>
        <div class="alert alert-success"><?= htmlspecialchars($successMsg) ?></div>
    <?php endif; ?>
    <?php if ($errorMsg): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($errorMsg) ?></div>
    <?php endif; ?>

    <form method="post" class="card p-4 shadow-sm">
        <div class="mb-3">
            <label class="form-label">Assignment Title</label>
            <input type="text" name="title" class="form-control" value="<?= htmlspecialchars($_POST['title'] ?? '') ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Description / Instructions</label>
            <textarea name="description" class="form-control" rows="4" required><?= htmlspecialchars($_POST['description'] ?? '') ?></textarea>
        </div>

        <div class="mb-3">
            <label class="form-label">Course</label>
            <select name="course_id" class="form-select" required>
                <option value="" disabled selected>Select a course</option>
                <?php foreach ($courses as $c): ?>
                    <option value="<?= $c['id'] ?>" <?= (($_POST['course_id'] ?? '') == $c['id']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($c['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">Due Date & Time</label>
            <input type="datetime-local" name="due_date" class="form-control" value="<?= htmlspecialchars($_POST['due_date'] ?? '') ?>" required>
        </div>

        <button type="submit" class="btn btn-success">💾 Create Assignment</button>
        <a href="assignments.php" class="btn btn-secondary">⬅ Back</a>
    </form>
</div>
