<?php
require_once 'config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];
$assessment_id = $_GET['id'] ?? 0;

/* SECURITY CHECK */
$check = $pdo->prepare("
SELECT a.assessment_title, a.duration
FROM assessments a
JOIN courses c ON a.course_id = c.id
JOIN subscriptions s ON s.category_id = c.category_id
WHERE a.id = :aid
AND s.user_id = :uid
AND s.status = 'active'
");
$check->execute(['aid'=>$assessment_id, 'uid'=>$user_id]);
$assessment = $check->fetch();

if (!$assessment) {
    die("Access denied");
}

/* QUESTIONS */
$q = $pdo->prepare("SELECT * FROM questions WHERE assessment_id = :aid" ORDER BY RAND());
$q->execute(['aid'=>$assessment_id]);
$questions = $q->fetchAll();
$total = count($questions);

if ($total === 0) {
    die("No questions added yet.");
}
?>

<!doctype html>
<html>
<head>
<title>CBT Exam</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.question { display:none; }
.question.active { display:block; }
</style>
</head>
<body>

<div class="container mt-4">
  <h4><?= htmlspecialchars($assessment['assessment_title']) ?></h4>
  <div class="alert alert-warning">
    ⏱ Time Left: <span id="time"></span>
  </div>

<form method="post" action="submit_assessment.php" id="cbtForm">
<input type="hidden" name="assessment_id" value="<?= $assessment_id ?>">

<?php foreach($questions as $i => $q): ?>
<div class="question <?= $i==0?'active':'' ?>">
  <h5>Question <?= $i+1 ?></h5>
  <p><?= htmlspecialchars($q['question']) ?></p>

  <?php foreach(['a','b','c','d'] as $opt): ?>
    <div class="form-check">
      <input class="form-check-input" type="radio"
        name="answers[<?= $q['id'] ?>]"
        value="<?= $opt ?>">
      <label class="form-check-label">
        <?= htmlspecialchars($q['option_'.$opt]) ?>
      </label>
    </div>
  <?php endforeach; ?>
</div>
<?php endforeach; ?>

<div class="mt-3">
  <button type="button" class="btn btn-secondary" onclick="prevQ()">Previous</button>
  <button type="button" class="btn btn-secondary" onclick="nextQ()">Next</button>
  <button type="submit" class="btn btn-danger">Submit</button>
</div>
</form>
</div>

<!-- Disable Refresh / Back Button -->
<script>
history.pushState(null,null,location.href);
window.onpopstate = () => history.pushState(null,null,location.href);
</script>

<!-- Tab Switching Detection (Auto Submit) -->
<script>
document.addEventListener("visibilitychange", function(){
  if(document.hidden){
    alert("Tab switch detected. Exam will submit.");
    document.getElementById("cbtForm").submit();
  }
});
</script>


<!-- Disable Right-Click, Copy, Paste -->
<script>
document.addEventListener("contextmenu", e=>e.preventDefault());
document.addEventListener("copy", e=>e.preventDefault());
document.addEventListener("paste", e=>e.preventDefault());
</script>




<script>
let q = document.querySelectorAll('.question');
let index = 0;

function showQ(i){
  q.forEach(x=>x.classList.remove('active'));
  q[i].classList.add('active');
}

function nextQ(){
  if(index < q.length-1){ index++; showQ(index); }
}
function prevQ(){
  if(index > 0){ index--; showQ(index); }
}

/* TIMER */
let time = <?= $assessment['duration'] * 60 ?>;
let timer = setInterval(()=>{
  let m = Math.floor(time/60);
  let s = time % 60;
  document.getElementById('time').innerText = m+":"+ (s<10?'0':'')+s;
  time--;
  if(time < 0){
    clearInterval(timer);
    document.getElementById('cbtForm').submit();
  }
},1000);
</script>


</body>
</html>
