<?php
session_start();
require_once 'php/config.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php?redirect=subscriptions.php");
    exit;
}

$user = $_SESSION['user'];

// Fetch user's subscriptions
$stmt = $pdo->prepare("
    SELECT s.*, c.name AS course_name, c.file AS course_file
    FROM subscriptions s
    LEFT JOIN courses c ON c.id = s.course_id
    WHERE s.user_id = :user_id
    ORDER BY s.created_at DESC
");
$stmt->execute([':user_id' => $user['id']]);
$subscriptions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Subscriptions</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background-color: #f8f9fa; }
.card { margin-bottom: 15px; }
.status-paid { color: green; font-weight: bold; }
.status-pending { color: orange; font-weight: bold; }
.status-failed { color: red; font-weight: bold; }
</style>
</head>
<body>
<div class="container py-5">
    <h2 class="mb-4">📄 My Subscriptions</h2>

    <?php if(empty($subscriptions)): ?>
        <div class="alert alert-warning">
            You have not subscribed to any courses yet. 
            <a href="courses.php">Browse Courses</a>
        </div>
    <?php else: ?>
        <div class="row">
            <?php foreach($subscriptions as $sub): ?>
                <div class="col-md-6">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h5 class="card-title"><?= htmlspecialchars($sub['course_name']) ?></h5>
                            <p class="card-text">
                                <strong>Plan:</strong> <?= htmlspecialchars($sub['plan']) ?><br>
                                <strong>Amount:</strong> ₦<?= number_format($sub['amount'], 2) ?><br>
                                <strong>Payment Method:</strong> <?= htmlspecialchars($sub['payment_method']) ?><br>
                                <strong>Status:</strong> 
                                <?php
                                if($sub['payment_status'] === 'paid') echo '<span class="status-paid">Paid</span>';
                                elseif($sub['payment_status'] === 'pending') echo '<span class="status-pending">Pending</span>';
                                else echo '<span class="status-failed">Failed</span>';
                                ?><br>
                                <strong>Subscribed On:</strong> <?= date("d M Y, h:i A", strtotime($sub['created_at'])) ?><br>
                                <strong>Start Date:</strong> <?= $sub['start_date'] ? date("d M Y", strtotime($sub['start_date'])) : '-' ?><br>
                                <strong>End Date:</strong> <?= $sub['end_date'] ? date("d M Y", strtotime($sub['end_date'])) : '-' ?>
                            </p>

                            <?php if($sub['payment_status'] === 'paid'): ?>
                                <a href="live_classes.php?course_id=<?= $sub['course_id'] ?>" class="btn btn-success w-100">
                                    🎬 Go to Course
                                </a>
                            <?php elseif($sub['payment_status'] === 'pending'): ?>
                                <span class="btn btn-warning w-100">⏳ Payment Pending</span>
                            <?php else: ?>
                                <span class="btn btn-danger w-100">❌ Payment Failed</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <div class="mt-4">
        <a href="dashboard.php" class="btn btn-secondary">⬅ Back to Dashboard</a>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
