<?php
session_start();
require_once 'php/config.php';

if (!is_logged_in()) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user']['id'];
$assignment_id = $_GET['id'] ?? 0;

// Fetch assignment details
$stmt = $pdo->prepare("SELECT * FROM assignments WHERE id = ?");
$stmt->execute([$assignment_id]);
$assignment = $stmt->fetch();

// Fetch previous submission if any
$subStmt = $pdo->prepare("
    SELECT * FROM assignment_submissions
    WHERE assignment_id = :aid AND user_id = :uid
    ORDER BY submitted_at DESC
    LIMIT 1
");
$subStmt->execute([
    'aid' => $assignment_id,
    'uid' => $user_id
]);
$previous = $subStmt->fetch();

// Handle new submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $answer = $_POST['answer'] ?? '';
    
    // optional: handle file upload
    $filePath = $previous['file_path'] ?? null; // keep previous if none uploaded
    if (!empty($_FILES['file']['name'])) {
        $uploadDir = 'uploads/assignments/';
        $filePath = $uploadDir . time() . '_' . basename($_FILES['file']['name']);
        move_uploaded_file($_FILES['file']['tmp_name'], $filePath);
    }

    $stmt = $pdo->prepare("
        INSERT INTO assignment_submissions (assignment_id, user_id, answer, file_path)
        VALUES (:aid, :uid, :answer, :file)
    ");
    $stmt->execute([
        'aid' => $assignment_id,
        'uid' => $user_id,
        'answer' => $answer,
        'file' => $filePath
    ]);

    header("Location: assignments.php");
    exit;
}
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">📄 Submit Assignment: <?= htmlspecialchars($assignment['title']) ?></h4>
                </div>
                <div class="card-body">

                    <!-- Previous Submission Preview -->
                    <?php if ($previous): ?>
                        <div class="alert alert-info">
                            <h6 class="fw-semibold">📝 Previous Submission</h6>
                            <p><strong>Answer:</strong></p>
                            <div class="border p-2 mb-2"><?= nl2br(htmlspecialchars($previous['answer'])) ?></div>
                            <?php if ($previous['file_path']): ?>
                                <p><strong>Uploaded File:</strong> 
                                    <a href="<?= htmlspecialchars($previous['file_path']) ?>" target="_blank">View File</a>
                                </p>
                            <?php endif; ?>
                            <small class="text-muted">Submitted on: <?= date('d M Y, H:i', strtotime($previous['submitted_at'])) ?></small>
                        </div>
                    <?php endif; ?>

                    <!-- New Submission Form -->
                    <form method="post" enctype="multipart/form-data" class="needs-validation" novalidate>
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Answer / Notes</label>
                            <textarea name="answer" class="form-control" rows="6" placeholder="Write your answer here..." required><?= htmlspecialchars($previous['answer'] ?? '') ?></textarea>
                            <div class="invalid-feedback">
                                Please provide your answer.
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label fw-semibold">Upload File (optional)</label>
                            <input type="file" name="file" class="form-control">
                            <?php if ($previous['file_path']): ?>
                                <small class="text-muted">Current file: <a href="<?= htmlspecialchars($previous['file_path']) ?>" target="_blank">View</a></small>
                            <?php endif; ?>
                        </div>

                        <div class="d-flex justify-content-between">
                            <button type="submit" class="btn btn-success">
                                ✅ Submit Assignment
                            </button>
                            <a href="assignments.php" class="btn btn-secondary">
                                ⬅ Back to Assignments
                            </a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Bootstrap 5 validation
(() => {
    'use strict'
    const forms = document.querySelectorAll('.needs-validation')
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault()
                event.stopPropagation()
            }
            form.classList.add('was-validated')
        }, false)
    })
})();
</script>
